/*
 * Decompiled with CFR 0.152.
 */
package ai.ancf.lmos.arc.spring;

import ai.ancf.lmos.arc.agents.Agent;
import ai.ancf.lmos.arc.agents.AgentLoader;
import ai.ancf.lmos.arc.agents.AgentProvider;
import ai.ancf.lmos.arc.agents.CompositeAgentProvider;
import ai.ancf.lmos.arc.agents.dsl.AgentFactory;
import ai.ancf.lmos.arc.agents.dsl.BeanProvider;
import ai.ancf.lmos.arc.agents.dsl.ChatAgentFactory;
import ai.ancf.lmos.arc.agents.dsl.CoroutineBeanProvider;
import ai.ancf.lmos.arc.agents.events.BasicEventPublisher;
import ai.ancf.lmos.arc.agents.events.EventHandler;
import ai.ancf.lmos.arc.agents.events.EventListeners;
import ai.ancf.lmos.arc.agents.events.EventPublisher;
import ai.ancf.lmos.arc.agents.events.EventPublisherKt;
import ai.ancf.lmos.arc.agents.events.LoggingEventHandler;
import ai.ancf.lmos.arc.agents.functions.CompositeLLMFunctionProvider;
import ai.ancf.lmos.arc.agents.functions.LLMFunction;
import ai.ancf.lmos.arc.agents.functions.LLMFunctionLoader;
import ai.ancf.lmos.arc.agents.functions.LLMFunctionProvider;
import ai.ancf.lmos.arc.agents.llm.TextEmbedderProvider;
import ai.ancf.lmos.arc.agents.memory.InMemoryMemory;
import ai.ancf.lmos.arc.agents.memory.Memory;
import ai.ancf.lmos.arc.agents.router.SemanticRouter;
import ai.ancf.lmos.arc.agents.router.SemanticRoutes;
import ai.ancf.lmos.arc.scripting.ScriptHotReload;
import ai.ancf.lmos.arc.scripting.agents.AgentScriptEngine;
import ai.ancf.lmos.arc.scripting.agents.CompiledAgentLoader;
import ai.ancf.lmos.arc.scripting.agents.KtsAgentScriptEngine;
import ai.ancf.lmos.arc.scripting.agents.ScriptingAgentLoader;
import ai.ancf.lmos.arc.scripting.functions.FunctionScriptEngine;
import ai.ancf.lmos.arc.scripting.functions.KtsFunctionScriptEngine;
import ai.ancf.lmos.arc.scripting.functions.ScriptingLLMFunctionLoader;
import ai.ancf.lmos.arc.spring.Agents;
import ai.ancf.lmos.arc.spring.ClientsConfiguration;
import ai.ancf.lmos.arc.spring.Functions;
import ai.ancf.lmos.arc.spring.Langchain4jConfiguration;
import ai.ancf.lmos.arc.spring.MetricConfiguration;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@Import(value={MetricConfiguration.class, ClientsConfiguration.class, Langchain4jConfiguration.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0007J6\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\b\u001a\u00020!H\u0007J2\u0010\"\u001a\u00020#2\u000e\b\u0001\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000b2\b\b\u0001\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0007J,\u0010\u001d\u001a\u00020\u001e2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u000b2\u0014\u0010.\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/0\u000bH\u0007J>\u00100\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\r\u001a\u0006\u0012\u0002\b\u0003012\u000e\u00102\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010\u000b2\b\b\u0001\u00104\u001a\u00020%2\u0006\u0010\b\u001a\u00020!H\u0007J$\u00105\u001a\u0002062\f\u0010,\u001a\b\u0012\u0004\u0012\u0002070\u000b2\f\u00108\u001a\b\u0012\u0004\u0012\u0002090\u000bH\u0007J*\u0010:\u001a\u00020+2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u00104\u001a\u00020%2\u0006\u0010\b\u001a\u00020!H\u0007J\u0014\u0010(\u001a\u00020;2\n\u0010\r\u001a\u0006\u0012\u0002\b\u000301H\u0007J\u0010\u0010*\u001a\u00020<2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006="}, d2={"Lai/ancf/lmos/arc/spring/ArcAutoConfiguration;", "", "<init>", "()V", "beanProvider", "Lai/ancf/lmos/arc/agents/dsl/BeanProvider;", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "eventPublisher", "Lai/ancf/lmos/arc/agents/events/BasicEventPublisher;", "eventHandlers", "", "Lai/ancf/lmos/arc/agents/events/EventHandler;", "agentFactory", "Lai/ancf/lmos/arc/agents/dsl/ChatAgentFactory;", "functionScriptEngine", "Lai/ancf/lmos/arc/scripting/functions/FunctionScriptEngine;", "agentScriptEngine", "Lai/ancf/lmos/arc/scripting/agents/AgentScriptEngine;", "memory", "Lai/ancf/lmos/arc/agents/memory/InMemoryMemory;", "loggingEventHandler", "Lai/ancf/lmos/arc/agents/events/LoggingEventHandler;", "semanticRouter", "Lai/ancf/lmos/arc/agents/router/SemanticRouter;", "model", "", "textEmbedderProvider", "Lai/ancf/lmos/arc/agents/llm/TextEmbedderProvider;", "agentProvider", "Lai/ancf/lmos/arc/agents/AgentProvider;", "initialRoutes", "Lai/ancf/lmos/arc/agents/router/SemanticRoutes;", "Lai/ancf/lmos/arc/agents/events/EventPublisher;", "scriptHotReload", "Lai/ancf/lmos/arc/scripting/ScriptHotReload;", "agentsFolders", "Ljava/io/File;", "hotReloadDelay", "Ljava/time/Duration;", "agentLoader", "Lai/ancf/lmos/arc/scripting/agents/ScriptingAgentLoader;", "functionLoader", "Lai/ancf/lmos/arc/scripting/functions/ScriptingLLMFunctionLoader;", "loaders", "Lai/ancf/lmos/arc/agents/AgentLoader;", "agents", "Lai/ancf/lmos/arc/agents/Agent;", "scriptingAgentLoader", "Lai/ancf/lmos/arc/agents/dsl/AgentFactory;", "compiledAgents", "Lai/ancf/lmos/arc/scripting/agents/CompiledAgentLoader;", "agentsFolder", "llmFunctionProvider", "Lai/ancf/lmos/arc/agents/functions/LLMFunctionProvider;", "Lai/ancf/lmos/arc/agents/functions/LLMFunctionLoader;", "functions", "Lai/ancf/lmos/arc/agents/functions/LLMFunction;", "scriptingLLMFunctionProvider", "Lai/ancf/lmos/arc/spring/Agents;", "Lai/ancf/lmos/arc/spring/Functions;", "arc-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nArcAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArcAutoConfiguration.kt\nai/ancf/lmos/arc/spring/ArcAutoConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,144:1\n1863#2,2:145\n1863#2:147\n1864#2:150\n1863#2,2:151\n1317#3,2:148\n1317#3,2:153\n1317#3,2:155\n*S KotlinDebug\n*F\n+ 1 ArcAutoConfiguration.kt\nai/ancf/lmos/arc/spring/ArcAutoConfiguration\n*L\n97#1:145,2\n99#1:147\n99#1:150\n117#1:151,2\n99#1:148,2\n118#1:153,2\n134#1:155,2\n*E\n"})
public final class ArcAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BeanProvider.class})
    @NotNull
    public final BeanProvider beanProvider(@NotNull ConfigurableBeanFactory beanFactory) {
        Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
        return (BeanProvider)new CoroutineBeanProvider(new BeanProvider(beanFactory){
            final /* synthetic */ ConfigurableBeanFactory $beanFactory;
            {
                this.$beanFactory = $beanFactory;
            }

            public <T> Object provide(KClass<T> bean, Continuation<? super T> $completion) {
                return this.$beanFactory.getBean(JvmClassMappingKt.getJavaClass(bean));
            }
        });
    }

    @Bean
    @NotNull
    public final BasicEventPublisher eventPublisher(@NotNull List<? extends EventHandler<?>> eventHandlers) {
        BasicEventPublisher basicEventPublisher;
        Intrinsics.checkNotNullParameter(eventHandlers, (String)"eventHandlers");
        BasicEventPublisher $this$eventPublisher_u24lambda_u240 = basicEventPublisher = new BasicEventPublisher();
        boolean bl = false;
        EventPublisherKt.addAll((EventListeners)((EventListeners)$this$eventPublisher_u24lambda_u240), eventHandlers);
        return basicEventPublisher;
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentFactory.class})
    @NotNull
    public final ChatAgentFactory agentFactory(@NotNull BeanProvider beanProvider2) {
        Intrinsics.checkNotNullParameter((Object)beanProvider2, (String)"beanProvider");
        return new ChatAgentFactory(beanProvider2);
    }

    @Bean
    @NotNull
    public final FunctionScriptEngine functionScriptEngine() {
        return (FunctionScriptEngine)new KtsFunctionScriptEngine();
    }

    @Bean
    @NotNull
    public final AgentScriptEngine agentScriptEngine() {
        return (AgentScriptEngine)new KtsAgentScriptEngine();
    }

    @Bean
    @ConditionalOnMissingBean(value={Memory.class})
    @NotNull
    public final InMemoryMemory memory() {
        return new InMemoryMemory();
    }

    @Bean
    @NotNull
    public final LoggingEventHandler loggingEventHandler() {
        return new LoggingEventHandler();
    }

    @Bean
    @ConditionalOnProperty(value={"arc.router.enable"}, havingValue="true")
    @NotNull
    public final SemanticRouter semanticRouter(@Value(value="${arc.router.model}") @NotNull String model, @NotNull TextEmbedderProvider textEmbedderProvider, @NotNull AgentProvider agentProvider, @Nullable SemanticRoutes initialRoutes, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)textEmbedderProvider, (String)"textEmbedderProvider");
        Intrinsics.checkNotNullParameter((Object)agentProvider, (String)"agentProvider");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        return new SemanticRouter(textEmbedderProvider.provideByModel(model), initialRoutes, eventPublisher);
    }

    public static /* synthetic */ SemanticRouter semanticRouter$default(ArcAutoConfiguration arcAutoConfiguration, String string, TextEmbedderProvider textEmbedderProvider, AgentProvider agentProvider, SemanticRoutes semanticRoutes, EventPublisher eventPublisher, int n, Object object) {
        if ((n & 8) != 0) {
            semanticRoutes = null;
        }
        return arcAutoConfiguration.semanticRouter(string, textEmbedderProvider, agentProvider, semanticRoutes, eventPublisher);
    }

    @Bean
    @ConditionalOnProperty(value={"arc.scripts.hotReload.enable"}, havingValue="true")
    @NotNull
    public final ScriptHotReload scriptHotReload(@Value(value="${arc.scripts.folder:/agents}") @NotNull List<? extends File> agentsFolders, @Value(value="${arc.scripts.hotReload.delay:PT3M}") @NotNull java.time.Duration hotReloadDelay, @NotNull ScriptingAgentLoader agentLoader, @NotNull ScriptingLLMFunctionLoader functionLoader) {
        Intrinsics.checkNotNullParameter(agentsFolders, (String)"agentsFolders");
        Intrinsics.checkNotNullParameter((Object)hotReloadDelay, (String)"hotReloadDelay");
        Intrinsics.checkNotNullParameter((Object)agentLoader, (String)"agentLoader");
        Intrinsics.checkNotNullParameter((Object)functionLoader, (String)"functionLoader");
        Iterable $this$forEach$iv = agentsFolders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.exists()) continue;
            throw new IllegalStateException(("Agents folder does not exist: " + it + "!").toString());
        }
        java.time.Duration duration = hotReloadDelay;
        java.time.Duration r = duration = new ScriptHotReload(agentLoader, functionLoader, Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS)), null);
        boolean bl = false;
        Iterable $this$forEach$iv2 = agentsFolders;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            File folder = (File)element$iv;
            boolean bl2 = false;
            Sequence $this$forEach$iv3 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)folder, null, (int)1, null)), ArcAutoConfiguration::scriptHotReload$lambda$5$lambda$4$lambda$2);
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                File it = (File)element$iv2;
                boolean bl3 = false;
                r.start(it);
            }
        }
        return duration;
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentProvider.class})
    @NotNull
    public final AgentProvider agentProvider(@NotNull List<? extends AgentLoader> loaders, @NotNull List<? extends Agent<?, ?>> agents) {
        Intrinsics.checkNotNullParameter(loaders, (String)"loaders");
        Intrinsics.checkNotNullParameter(agents, (String)"agents");
        return (AgentProvider)new CompositeAgentProvider(loaders, agents);
    }

    @Bean
    @NotNull
    public final ScriptingAgentLoader scriptingAgentLoader(@NotNull AgentScriptEngine agentScriptEngine, @NotNull AgentFactory<?> agentFactory, @Nullable List<? extends CompiledAgentLoader> compiledAgents, @Value(value="${arc.scripts.folder:/agents}") @NotNull File agentsFolder, @NotNull EventPublisher eventPublisher) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        ScriptingAgentLoader scriptingAgentLoader;
        Intrinsics.checkNotNullParameter((Object)agentScriptEngine, (String)"agentScriptEngine");
        Intrinsics.checkNotNullParameter(agentFactory, (String)"agentFactory");
        Intrinsics.checkNotNullParameter((Object)agentsFolder, (String)"agentsFolder");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        ScriptingAgentLoader loader = scriptingAgentLoader = new ScriptingAgentLoader(agentFactory, agentScriptEngine, eventPublisher);
        boolean bl = false;
        List<? extends CompiledAgentLoader> list = compiledAgents;
        if (list != null) {
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompiledAgentLoader p0 = (CompiledAgentLoader)element$iv;
                boolean bl2 = false;
                loader.loadCompiledAgent(p0);
            }
        }
        if (agentsFolder.exists()) {
            $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)agentsFolder, null, (int)1, null)), ArcAutoConfiguration::scriptingAgentLoader$lambda$8$lambda$6);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl3 = false;
                File[] fileArray = new File[]{it};
                loader.loadAgents(fileArray);
            }
        }
        return scriptingAgentLoader;
    }

    @Bean
    @NotNull
    public final LLMFunctionProvider llmFunctionProvider(@NotNull List<? extends LLMFunctionLoader> loaders, @NotNull List<? extends LLMFunction> functions) {
        Intrinsics.checkNotNullParameter(loaders, (String)"loaders");
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        return (LLMFunctionProvider)new CompositeLLMFunctionProvider(loaders, functions);
    }

    @Bean
    @NotNull
    public final ScriptingLLMFunctionLoader scriptingLLMFunctionProvider(@NotNull FunctionScriptEngine functionScriptEngine, @NotNull BeanProvider beanProvider2, @Value(value="${arc.scripts.folder:/agents}") @NotNull File agentsFolder, @NotNull EventPublisher eventPublisher) {
        ScriptingLLMFunctionLoader scriptingLLMFunctionLoader;
        Intrinsics.checkNotNullParameter((Object)functionScriptEngine, (String)"functionScriptEngine");
        Intrinsics.checkNotNullParameter((Object)beanProvider2, (String)"beanProvider");
        Intrinsics.checkNotNullParameter((Object)agentsFolder, (String)"agentsFolder");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        ScriptingLLMFunctionLoader loader = scriptingLLMFunctionLoader = new ScriptingLLMFunctionLoader(beanProvider2, functionScriptEngine, eventPublisher);
        boolean bl = false;
        if (agentsFolder.exists()) {
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)agentsFolder, null, (int)1, null)), ArcAutoConfiguration::scriptingLLMFunctionProvider$lambda$11$lambda$9);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl2 = false;
                File[] fileArray = new File[]{it};
                loader.loadFunctions(fileArray);
            }
        }
        return scriptingLLMFunctionLoader;
    }

    @Bean
    @NotNull
    public final Agents agentLoader(@NotNull AgentFactory<?> agentFactory) {
        Intrinsics.checkNotNullParameter(agentFactory, (String)"agentFactory");
        return new Agents(agentFactory);
    }

    @Bean
    @NotNull
    public final Functions functionLoader(@NotNull BeanProvider beanProvider2) {
        Intrinsics.checkNotNullParameter((Object)beanProvider2, (String)"beanProvider");
        return new Functions(beanProvider2);
    }

    private static final boolean scriptHotReload$lambda$5$lambda$4$lambda$2(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isDirectory();
    }

    private static final boolean scriptingAgentLoader$lambda$8$lambda$6(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile();
    }

    private static final boolean scriptingLLMFunctionProvider$lambda$11$lambda$9(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile();
    }
}

