/*
 * Decompiled with CFR 0.152.
 */
package ai.ancf.lmos.router.vector;

import ai.ancf.lmos.router.core.AgentRoutingSpec;
import ai.ancf.lmos.router.core.Failure;
import ai.ancf.lmos.router.core.Result;
import ai.ancf.lmos.router.core.ResultKt;
import ai.ancf.lmos.router.core.Success;
import ai.ancf.lmos.router.vector.DefaultEmbeddingClient;
import ai.ancf.lmos.router.vector.DefaultEmbeddingClientProperties;
import ai.ancf.lmos.router.vector.DefaultVectorClientProperties;
import ai.ancf.lmos.router.vector.DefaultVectorDocument;
import ai.ancf.lmos.router.vector.EmbeddingClient;
import ai.ancf.lmos.router.vector.UtilsKt;
import ai.ancf.lmos.router.vector.VectorClientException;
import ai.ancf.lmos.router.vector.VectorSearchClient;
import ai.ancf.lmos.router.vector.VectorSearchClientRequest;
import ai.ancf.lmos.router.vector.VectorSearchClientResponse;
import ai.ancf.lmos.router.vector.VectorSeedClient;
import ai.ancf.lmos.router.vector.VectorSeedRequest;
import io.ktor.client.HttpClientJvmKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ,\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f0\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lai/ancf/lmos/router/vector/DefaultVectorClient;", "Lai/ancf/lmos/router/vector/VectorSearchClient;", "Lai/ancf/lmos/router/vector/VectorSeedClient;", "vectorClientProperties", "Lai/ancf/lmos/router/vector/DefaultVectorClientProperties;", "embeddingClient", "Lai/ancf/lmos/router/vector/EmbeddingClient;", "<init>", "(Lai/ancf/lmos/router/vector/DefaultVectorClientProperties;Lai/ancf/lmos/router/vector/EmbeddingClient;)V", "documents", "", "Lai/ancf/lmos/router/vector/DefaultVectorDocument;", "find", "Lai/ancf/lmos/router/core/Result;", "Lai/ancf/lmos/router/vector/VectorSearchClientResponse;", "Lai/ancf/lmos/router/vector/VectorClientException;", "request", "Lai/ancf/lmos/router/vector/VectorSearchClientRequest;", "agentRoutingSpecs", "", "Lai/ancf/lmos/router/core/AgentRoutingSpec;", "seed", "", "", "Lai/ancf/lmos/router/vector/VectorSeedRequest;", "lmos-router-vector"})
@SourceDebugExtension(value={"SMAP\nVectorClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorClient.kt\nai/ancf/lmos/router/vector/DefaultVectorClient\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n147#2:129\n774#3:130\n865#3:131\n1755#3,3:132\n866#3:135\n1062#3:136\n1557#3:137\n1628#3,3:138\n1485#3:141\n1510#3,3:142\n1513#3,3:152\n1557#3:156\n1628#3,3:157\n1872#3,3:160\n381#4,7:145\n1#5:155\n*S KotlinDebug\n*F\n+ 1 VectorClient.kt\nai/ancf/lmos/router/vector/DefaultVectorClient\n*L\n62#1:129\n74#1:130\n74#1:131\n74#1:132,3\n74#1:135\n75#1:136\n77#1:137\n77#1:138,3\n78#1:141\n78#1:142,3\n78#1:152,3\n86#1:156\n86#1:157,3\n88#1:160,3\n78#1:145,7\n*E\n"})
public final class DefaultVectorClient
implements VectorSearchClient,
VectorSeedClient {
    @NotNull
    private final DefaultVectorClientProperties vectorClientProperties;
    @NotNull
    private final EmbeddingClient embeddingClient;
    @NotNull
    private final List<DefaultVectorDocument> documents;

    public DefaultVectorClient(@NotNull DefaultVectorClientProperties vectorClientProperties, @NotNull EmbeddingClient embeddingClient) {
        Intrinsics.checkNotNullParameter((Object)vectorClientProperties, (String)"vectorClientProperties");
        Intrinsics.checkNotNullParameter((Object)embeddingClient, (String)"embeddingClient");
        this.vectorClientProperties = vectorClientProperties;
        this.embeddingClient = embeddingClient;
        this.documents = new ArrayList();
        if (((CharSequence)this.vectorClientProperties.getSeedJsonFilePath()).length() > 0) {
            File jsonFile = new File(this.vectorClientProperties.getSeedJsonFilePath());
            String json = FilesKt.readText$default((File)jsonFile, null, (int)1, null);
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            List vectorSeedRequests = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(VectorSeedRequest.Companion.serializer()), json);
            ResultKt.getOrThrow(this.seed(vectorSeedRequests));
        }
    }

    public /* synthetic */ DefaultVectorClient(DefaultVectorClientProperties defaultVectorClientProperties, EmbeddingClient embeddingClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            embeddingClient = new DefaultEmbeddingClient(HttpClientJvmKt.HttpClient$default(null, (int)1, null), new DefaultEmbeddingClientProperties(null, null, 3, null));
        }
        this(defaultVectorClientProperties, embeddingClient);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<VectorSearchClientResponse, VectorClientException> find(@NotNull VectorSearchClientRequest request, @NotNull Set<? extends AgentRoutingSpec> agentRoutingSpecs) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(agentRoutingSpecs, (String)"agentRoutingSpecs");
        try {
            Object object;
            Object v2;
            void $this$groupByTo$iv$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$sortedByDescending$iv;
            DefaultVectorDocument it;
            void $this$filterTo$iv$iv;
            List embeddings = (List)ResultKt.getOrThrow(this.embeddingClient.embed(request.getQuery()));
            Iterable $this$filter$iv = this.documents;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block15: {
                    it = (DefaultVectorDocument)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = agentRoutingSpecs;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            AgentRoutingSpec agentRoutingSpec = (AgentRoutingSpec)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)agentRoutingSpec.getName(), (Object)it.getAgentName())) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(embeddings){
                final /* synthetic */ List $embeddings$inlined;
                {
                    this.$embeddings$inlined = list;
                }

                public final int compare(T a, T b) {
                    DefaultVectorDocument it = (DefaultVectorDocument)b;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(UtilsKt.cosineSimilarity(this.$embeddings$inlined, it.getVector()));
                    it = (DefaultVectorDocument)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(UtilsKt.cosineSimilarity(this.$embeddings$inlined, it.getVector())));
                }
            }), (int)this.vectorClientProperties.getLimit());
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DefaultVectorDocument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new VectorSearchClientResponse(it.getText(), it.getAgentName()));
            }
            List result2 = (List)destination$iv$iv;
            Iterable $this$groupBy$iv = result2;
            boolean $i$f$groupBy = false;
            destination$iv$iv = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                VectorSearchClientResponse it2 = (VectorSearchClientResponse)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it2.getAgentName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = destination$iv$iv2.entrySet();
            Iterator iterator = iterable2.iterator();
            if (!iterator.hasNext()) {
                v2 = null;
            } else {
                Object t = iterator.next();
                if (!iterator.hasNext()) {
                    v2 = t;
                } else {
                    Map.Entry it3 = (Map.Entry)t;
                    boolean bl = false;
                    int n = ((List)it3.getValue()).size();
                    do {
                        Object t2 = iterator.next();
                        Map.Entry it4 = (Map.Entry)t2;
                        $i$a$-maxByOrNull-DefaultVectorClient$find$2 = false;
                        int n2 = ((List)it4.getValue()).size();
                        if (n >= n2) continue;
                        t = t2;
                        n = n2;
                    } while (iterator.hasNext());
                    v2 = t;
                }
            }
            VectorSearchClientResponse vectorSearchClientResponse = (object = (Map.Entry)v2) != null && (object = (List)object.getValue()) != null ? (VectorSearchClientResponse)CollectionsKt.first((List)object) : null;
            result = (Result)new Success((Object)vectorSearchClientResponse);
        }
        catch (Exception e) {
            result = (Result)new Failure((Exception)new VectorClientException("Failed to find documents", e));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<Unit, VectorClientException> seed(@NotNull List<? extends VectorSeedRequest> documents) {
        Result result;
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = documents;
            EmbeddingClient embeddingClient = this.embeddingClient;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VectorSeedRequest vectorSeedRequest = (VectorSeedRequest)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getText());
            }
            List batchEmbeddings = (List)ResultKt.getOrThrow(embeddingClient.batchEmbed((List)destination$iv$iv));
            Iterable $this$forEachIndexed$iv = batchEmbeddings;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void embeddings;
                int n;
                Object item$iv$iv;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv = (List)item$iv;
                int index = n;
                boolean bl = false;
                this.documents.add(new DefaultVectorDocument(documents.get(index).getText(), (List<Double>)embeddings, documents.get(index).getAgentName()));
            }
            Unit unit = Unit.INSTANCE;
            result = (Result)new Success((Object)unit);
        }
        catch (Exception e) {
            result = (Result)new Failure((Exception)new VectorClientException("Failed to seed documents", e));
        }
        return result;
    }
}

