/*
 * Decompiled with CFR 0.152.
 */
package ai.ancf.lmos.router.vector;

import ai.ancf.lmos.router.core.AgentRoutingSpec;
import ai.ancf.lmos.router.core.AgentRoutingSpecResolverException;
import ai.ancf.lmos.router.core.AgentRoutingSpecsProvider;
import ai.ancf.lmos.router.core.AgentRoutingSpecsResolver;
import ai.ancf.lmos.router.core.Context;
import ai.ancf.lmos.router.core.Failure;
import ai.ancf.lmos.router.core.Result;
import ai.ancf.lmos.router.core.ResultKt;
import ai.ancf.lmos.router.core.SpecFilter;
import ai.ancf.lmos.router.core.Success;
import ai.ancf.lmos.router.core.UserMessage;
import ai.ancf.lmos.router.vector.DefaultVectorClient;
import ai.ancf.lmos.router.vector.DefaultVectorClientProperties;
import ai.ancf.lmos.router.vector.VectorSearchClient;
import ai.ancf.lmos.router.vector.VectorSearchClientRequest;
import ai.ancf.lmos.router.vector.VectorSearchClientResponse;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\n\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J4\u0010\n\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/ancf/lmos/router/vector/VectorAgentRoutingSpecsResolver;", "Lai/ancf/lmos/router/core/AgentRoutingSpecsResolver;", "agentRoutingSpecsProvider", "Lai/ancf/lmos/router/core/AgentRoutingSpecsProvider;", "vectorSearchClient", "Lai/ancf/lmos/router/vector/VectorSearchClient;", "<init>", "(Lai/ancf/lmos/router/core/AgentRoutingSpecsProvider;Lai/ancf/lmos/router/vector/VectorSearchClient;)V", "getAgentRoutingSpecsProvider", "()Lai/ancf/lmos/router/core/AgentRoutingSpecsProvider;", "resolve", "Lai/ancf/lmos/router/core/Result;", "Lai/ancf/lmos/router/core/AgentRoutingSpec;", "Lai/ancf/lmos/router/core/AgentRoutingSpecResolverException;", "context", "Lai/ancf/lmos/router/core/Context;", "input", "Lai/ancf/lmos/router/core/UserMessage;", "filters", "", "Lai/ancf/lmos/router/core/SpecFilter;", "lmos-router-vector"})
@SourceDebugExtension(value={"SMAP\nVectorAgentRoutingSpecsResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorAgentRoutingSpecsResolver.kt\nai/ancf/lmos/router/vector/VectorAgentRoutingSpecsResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n295#2,2:51\n*S KotlinDebug\n*F\n+ 1 VectorAgentRoutingSpecsResolver.kt\nai/ancf/lmos/router/vector/VectorAgentRoutingSpecsResolver\n*L\n44#1:51,2\n*E\n"})
public class VectorAgentRoutingSpecsResolver
implements AgentRoutingSpecsResolver {
    @NotNull
    private final AgentRoutingSpecsProvider agentRoutingSpecsProvider;
    @NotNull
    private final VectorSearchClient vectorSearchClient;

    public VectorAgentRoutingSpecsResolver(@NotNull AgentRoutingSpecsProvider agentRoutingSpecsProvider, @NotNull VectorSearchClient vectorSearchClient) {
        Intrinsics.checkNotNullParameter((Object)agentRoutingSpecsProvider, (String)"agentRoutingSpecsProvider");
        Intrinsics.checkNotNullParameter((Object)vectorSearchClient, (String)"vectorSearchClient");
        this.agentRoutingSpecsProvider = agentRoutingSpecsProvider;
        this.vectorSearchClient = vectorSearchClient;
    }

    public /* synthetic */ VectorAgentRoutingSpecsResolver(AgentRoutingSpecsProvider agentRoutingSpecsProvider, VectorSearchClient vectorSearchClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string = System.getenv("VECTOR_SEED_JSON_FILE_PATH");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
            vectorSearchClient = new DefaultVectorClient(new DefaultVectorClientProperties(string, 0, 2, null), null, 2, null);
        }
        this(agentRoutingSpecsProvider, vectorSearchClient);
    }

    @NotNull
    public AgentRoutingSpecsProvider getAgentRoutingSpecsProvider() {
        return this.agentRoutingSpecsProvider;
    }

    @NotNull
    public Result<AgentRoutingSpec, AgentRoutingSpecResolverException> resolve(@NotNull Context context, @NotNull UserMessage input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.resolve(SetsKt.emptySet(), context, input);
    }

    @NotNull
    public Result<AgentRoutingSpec, AgentRoutingSpecResolverException> resolve(@NotNull Set<? extends SpecFilter> filters, @NotNull Context context, @NotNull UserMessage input) {
        Result result;
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            Object v1;
            block3: {
                Set agentSpecs = (Set)ResultKt.getOrThrow((Result)this.getAgentRoutingSpecsProvider().provide(filters));
                VectorSearchClientResponse result2 = (VectorSearchClientResponse)ResultKt.getOrThrow(this.vectorSearchClient.find(new VectorSearchClientRequest(input.getContent(), context), agentSpecs));
                Iterable $this$firstOrNull$iv = agentSpecs;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AgentRoutingSpec it = (AgentRoutingSpec)element$iv;
                    boolean bl = false;
                    VectorSearchClientResponse vectorSearchClientResponse = result2;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)(vectorSearchClientResponse != null ? vectorSearchClientResponse.getAgentName() : null))) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            Object var12_13 = v1;
            result = (Result)new Success(var12_13);
        }
        catch (Exception e) {
            result = (Result)new Failure((Exception)new AgentRoutingSpecResolverException("Failed to resolve agent spec", e));
        }
        return result;
    }
}

