/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.AIServiceContext;
import java.util.TimeZone;
import java.util.UUID;

public class AIServiceContextBuilder {
    private String sessionId;
    private TimeZone timeZone;

    public String getSessionId() {
        return this.sessionId;
    }

    public AIServiceContextBuilder setSessionId(String sessionId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("sessionId cannot be null");
        }
        this.sessionId = sessionId;
        return this;
    }

    public AIServiceContextBuilder generateSessionId() {
        this.sessionId = AIServiceContextBuilder.createRandomSessionId();
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public AIServiceContextBuilder setSessionId(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public AIServiceContext build() {
        if (this.sessionId == null) {
            throw new IllegalStateException("Session id is undefined");
        }
        return new PlainAIServiceContext(this.sessionId, this.timeZone);
    }

    public static AIServiceContext buildFromSessionId(String sessionId) {
        return new AIServiceContextBuilder().setSessionId(sessionId).build();
    }

    private static String createRandomSessionId() {
        return UUID.randomUUID().toString();
    }

    private static class PlainAIServiceContext
    implements AIServiceContext {
        private final String sessionId;
        private final TimeZone timeZone;

        public PlainAIServiceContext(String sessionId, TimeZone timeZone) {
            assert (sessionId != null);
            this.sessionId = sessionId;
            this.timeZone = timeZone;
        }

        @Override
        public String getSessionId() {
            return this.sessionId;
        }

        @Override
        public TimeZone getTimeZone() {
            return this.timeZone;
        }
    }
}

