/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.model.ResponseMessage;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class GsonFactory {
    private static final Gson DEFAULT_GSON = new GsonBuilder().create();
    private static final Gson PROTOCOL_GSON = new GsonBuilder().setDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US).toPattern()).registerTypeAdapter(ResponseMessage.class, (Object)new ResponseItemAdapter()).registerTypeAdapter(ResponseMessage.ResponseSpeech.class, (Object)new ResponseSpeechDeserializer()).create();
    private static final GsonFactory DEFAULT_FACTORY = new GsonFactory();

    public Gson getGson() {
        return PROTOCOL_GSON;
    }

    public static GsonFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    private static class ResponseSpeechDeserializer
    implements JsonDeserializer<ResponseMessage> {
        private ResponseSpeechDeserializer() {
        }

        public ResponseMessage.ResponseSpeech deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && ((JsonObject)json).get("speech").isJsonPrimitive()) {
                JsonArray array = new JsonArray();
                array.add(((JsonObject)json).get("speech"));
                ((JsonObject)json).add("speech", (JsonElement)array);
            }
            return (ResponseMessage.ResponseSpeech)DEFAULT_GSON.fromJson(json, typeOfT);
        }
    }

    private static class ResponseItemAdapter
    implements JsonDeserializer<ResponseMessage>,
    JsonSerializer<ResponseMessage> {
        private ResponseItemAdapter() {
        }

        public ResponseMessage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int typeCode = json.getAsJsonObject().get("type").getAsInt();
            for (ResponseMessage.MessageType type : ResponseMessage.MessageType.values()) {
                if (type.getCode() != typeCode) continue;
                return (ResponseMessage)context.deserialize(json, type.getType());
            }
            throw new JsonParseException(String.format("Unexpected message type value: %d", typeCode));
        }

        public JsonElement serialize(ResponseMessage src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src, src.getClass());
        }
    }
}

