/*
 * Decompiled with CFR 0.152.
 */
package ai.api.model;

import ai.api.model.Entity;
import ai.api.model.Location;
import ai.api.util.StringUtils;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class QuestionMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SerializedName(value="timezone")
    private String timezone;
    @SerializedName(value="lang")
    private String language;
    @SerializedName(value="sessionId")
    private String sessionId;
    @SerializedName(value="entities")
    private List<Entity> entities;
    @SerializedName(value="location")
    private Location location;

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (StringUtils.isEmpty(language)) {
            throw new IllegalArgumentException("language must not be null");
        }
        this.language = language;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    public void addEntity(Entity entity) {
        if (this.entities == null) {
            this.entities = new ArrayList<Entity>();
        }
        this.entities.add(entity);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String toString() {
        return String.format("QuestionMetadata{language='%s', timezone='%s'}", this.language, this.timezone);
    }
}

