/*
 * Decompiled with CFR 0.152.
 */
package ai.api.model;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

public abstract class ResponseMessage {
    @Expose
    private int type;

    protected ResponseMessage(MessageType type) {
        assert (type != null);
        this.type = type.code;
    }

    public static class ResponsePayload
    extends ResponseMessage {
        @Expose
        private JsonObject payload;

        public ResponsePayload() {
            super(MessageType.PAYLOAD);
        }

        public JsonObject getPayload() {
            return this.payload;
        }

        public void setPayload(JsonObject payload) {
            this.payload = payload;
        }
    }

    public static class ResponseImage
    extends ResponseMessage {
        @Expose
        private String imageUrl;

        public ResponseImage() {
            super(MessageType.IMAGE);
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }
    }

    public static class ResponseQuickReply
    extends ResponseMessage {
        @Expose
        private String title;
        @Expose
        private List<String> replies;

        public ResponseQuickReply() {
            super(MessageType.QUICK_REPLY);
        }

        public List<String> getReplies() {
            return this.replies;
        }

        public void setReplies(List<String> replies) {
            this.replies = replies;
        }

        public void setReplies(String ... replies) {
            this.setReplies(Arrays.asList(replies));
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class ResponseCard
    extends ResponseMessage {
        @Expose
        private String title;
        @Expose
        private String subtitle;
        @Expose
        private String imageUrl;
        @Expose
        private List<Button> buttons;

        public ResponseCard() {
            super(MessageType.CARD);
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public List<Button> getButtons() {
            return this.buttons;
        }

        public void setButtons(List<Button> buttons) {
            this.buttons = buttons;
        }

        public void setButtons(Button ... buttons) {
            this.setButtons(Arrays.asList(buttons));
        }

        public static class Button {
            @Expose
            private String text;
            @Expose
            private String postback;

            public Button(String text, String postback) {
                this.text = text;
                this.postback = postback;
            }

            public void setText(String text) {
                this.text = text;
            }

            public String getText() {
                return this.text;
            }

            public void setPostback(String postback) {
                this.postback = postback;
            }

            public String getPostback() {
                return this.postback;
            }
        }
    }

    public static class ResponseSpeech
    extends ResponseMessage {
        @Expose
        public List<String> speech;

        public ResponseSpeech() {
            super(MessageType.SPEECH);
        }

        public List<String> getSpeech() {
            return this.speech;
        }

        public void setSpeech(List<String> speech) {
            this.speech = speech;
        }

        public void setSpeech(String ... speech) {
            this.setSpeech(Arrays.asList(speech));
        }
    }

    public static enum MessageType {
        SPEECH(0, (Type)((Object)ResponseSpeech.class)),
        CARD(1, (Type)((Object)ResponseCard.class)),
        QUICK_REPLY(2, (Type)((Object)ResponseQuickReply.class)),
        IMAGE(3, (Type)((Object)ResponseImage.class)),
        PAYLOAD(4, (Type)((Object)ResponsePayload.class));

        private final int code;
        private final Type type;

        private MessageType(int code, Type curClass) {
            this.code = code;
            this.type = curClass;
        }

        public int getCode() {
            return this.code;
        }

        public Type getType() {
            return this.type;
        }
    }
}

