/*
 * Decompiled with CFR 0.152.
 */
package ai.api.model;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Status
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, String> errorDescriptions = new HashMap<Integer, String>();
    private static final Map<Integer, String> errorTypes = new HashMap<Integer, String>();
    @SerializedName(value="code")
    private Integer code;
    @SerializedName(value="errorType")
    private String errorType;
    @SerializedName(value="errorDetails")
    private String errorDetails;
    @SerializedName(value="errorID")
    private String errorID;

    public Status() {
        errorDescriptions.put(400, "Some required parameter is missing or has wrong value. Details will be in the errorDetails field.");
        errorTypes.put(400, "bad_request");
        errorDescriptions.put(401, "Authorization failed. Please check your access keys.");
        errorTypes.put(401, "unauthorized");
        errorDescriptions.put(404, "Uri is not found or some resource with provided id is not found.");
        errorTypes.put(404, "not_found");
        errorDescriptions.put(405, "Attempting to use POST with a GET-only endpoint, or vice-versa.");
        errorTypes.put(405, "not_allowed");
        errorDescriptions.put(406, "Uploaded files have some problems with it.");
        errorTypes.put(406, "not_acceptable");
        errorDescriptions.put(409, "The request could not be completed due to a conflict with the current state of the resource. This code is only allowed in situations where it is expected that the user might be able to resolve the conflict and resubmit the request.");
        errorTypes.put(409, "conflict");
    }

    public static Status fromResponseCode(int responseCode) {
        Status status = new Status();
        status.setCode(responseCode);
        if (errorTypes.containsKey(responseCode)) {
            status.setErrorType(errorTypes.get(responseCode));
        }
        if (errorDescriptions.containsKey(responseCode)) {
            status.setErrorDetails(errorDescriptions.get(responseCode));
        }
        return status;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getErrorDetails() {
        if (this.code != null && errorDescriptions.containsKey(this.code)) {
            return errorDescriptions.get(this.code);
        }
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public String getErrorID() {
        return this.errorID;
    }

    public void setErrorID(String errorID) {
        this.errorID = errorID;
    }

    public String toString() {
        return String.format("Status{code=%d, errorType='%s', errorDetails='%s'}", this.code, this.errorType, this.errorDetails);
    }
}

