/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class AIConfiguration
implements Cloneable {
    private static final String SERVICE_PROD_URL = "https://api.api.ai/v1/";
    protected static final String CURRENT_PROTOCOL_VERSION = "20150910";
    protected static final String QUESTION_ENDPOINT = "query";
    protected static final String USER_ENTITIES_ENDPOINT = "userEntities";
    protected static final String CONTEXTS_ENDPOINT = "contexts";
    private final String apiKey;
    private final SupportedLanguages language;
    private String serviceUrl;
    private String protocolVersion;
    private boolean writeSoundLog = false;
    private Proxy proxy;
    private static Map<String, SupportedLanguages> STRING_TO_LANGUAGE = new HashMap<String, SupportedLanguages>();

    public AIConfiguration(String clientAccessToken, SupportedLanguages language) {
        if (clientAccessToken == null) {
            throw new IllegalArgumentException("clientAccessToken");
        }
        this.apiKey = clientAccessToken;
        this.language = language != null ? language : SupportedLanguages.DEFAULT;
        this.protocolVersion = CURRENT_PROTOCOL_VERSION;
        this.serviceUrl = SERVICE_PROD_URL;
    }

    public AIConfiguration(String clientAccessToken) {
        this(clientAccessToken, null);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getLanguage() {
        return this.language.languageTag;
    }

    public String getApiAiLanguage() {
        return this.language.apiaiLanguage;
    }

    public void setWriteSoundLog(boolean writeSoundLog) {
        this.writeSoundLog = writeSoundLog;
    }

    public boolean isWriteSoundLog() {
        return this.writeSoundLog;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public AIConfiguration clone() {
        try {
            AIConfiguration result = (AIConfiguration)super.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    String getQuestionUrl(String sessionId) {
        if (StringUtils.isEmpty(this.protocolVersion)) {
            return String.format("%s%s?sessionId=%s", this.serviceUrl, QUESTION_ENDPOINT, sessionId);
        }
        return String.format("%s%s?v=%s&sessionId=%s", this.serviceUrl, QUESTION_ENDPOINT, this.protocolVersion, sessionId);
    }

    String getUserEntitiesEndpoint(String sessionId) {
        if (StringUtils.isEmpty(this.protocolVersion)) {
            return String.format("%s%s?sessionId=%s", this.serviceUrl, USER_ENTITIES_ENDPOINT, sessionId);
        }
        return String.format("%s%s?v=%s&sessionId=%s", this.serviceUrl, USER_ENTITIES_ENDPOINT, this.protocolVersion, sessionId);
    }

    String getContextsUrl(String sessionId) {
        return this.getContextsUrl(sessionId, "");
    }

    String getContextsUrl(String sessionId, String suffix) {
        StringBuilder result = new StringBuilder();
        result.append(this.serviceUrl).append(CONTEXTS_ENDPOINT);
        if (!StringUtils.isEmpty(suffix)) {
            try {
                result.append("/").append(URLEncoder.encode(suffix, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        result.append("?");
        if (!StringUtils.isEmpty(this.protocolVersion)) {
            result.append("v=").append(this.protocolVersion).append("&");
        }
        result.append("sessionId=").append(sessionId);
        return result.toString();
    }

    public static final class SupportedLanguages
    extends Enum<SupportedLanguages> {
        public static final /* enum */ SupportedLanguages ChineseChina = new SupportedLanguages("zh-CN");
        public static final /* enum */ SupportedLanguages ChineseHongKong = new SupportedLanguages("zh-HK");
        public static final /* enum */ SupportedLanguages ChineseTaiwan = new SupportedLanguages("zh-TW");
        public static final /* enum */ SupportedLanguages English = new SupportedLanguages("en");
        public static final /* enum */ SupportedLanguages EnglishUS = new SupportedLanguages("en-US", "en");
        public static final /* enum */ SupportedLanguages EnglishGB = new SupportedLanguages("en-GB", "en");
        public static final /* enum */ SupportedLanguages Dutch = new SupportedLanguages("nl");
        public static final /* enum */ SupportedLanguages French = new SupportedLanguages("fr");
        public static final /* enum */ SupportedLanguages German = new SupportedLanguages("de");
        public static final /* enum */ SupportedLanguages Italian = new SupportedLanguages("it");
        public static final /* enum */ SupportedLanguages Japanese = new SupportedLanguages("ja");
        public static final /* enum */ SupportedLanguages Korean = new SupportedLanguages("ko");
        public static final /* enum */ SupportedLanguages Portuguese = new SupportedLanguages("pt");
        public static final /* enum */ SupportedLanguages PortugueseBrazil = new SupportedLanguages("pt-BR");
        public static final /* enum */ SupportedLanguages Russian = new SupportedLanguages("ru");
        public static final /* enum */ SupportedLanguages Spanish = new SupportedLanguages("es");
        public static final /* enum */ SupportedLanguages Ukrainian = new SupportedLanguages("uk");
        public static SupportedLanguages DEFAULT;
        private final String languageTag;
        private final String apiaiLanguage;
        private static final /* synthetic */ SupportedLanguages[] $VALUES;

        public static SupportedLanguages[] values() {
            return (SupportedLanguages[])$VALUES.clone();
        }

        public static SupportedLanguages valueOf(String name) {
            return Enum.valueOf(SupportedLanguages.class, name);
        }

        private SupportedLanguages(String languageTag) {
            this(languageTag, languageTag);
        }

        private SupportedLanguages(String languageTag, String apiaiLanguage) {
            assert (languageTag != null);
            assert (apiaiLanguage != null);
            this.languageTag = languageTag;
            this.apiaiLanguage = apiaiLanguage;
            SupportedLanguages retValue = STRING_TO_LANGUAGE.put(languageTag, this);
            assert (retValue == null) : "languageTag duplicates";
        }

        public static SupportedLanguages fromLanguageTag(String languageTag) {
            SupportedLanguages result = (SupportedLanguages)((Object)STRING_TO_LANGUAGE.get(languageTag));
            return result != null ? result : DEFAULT;
        }

        static {
            $VALUES = new SupportedLanguages[]{ChineseChina, ChineseHongKong, ChineseTaiwan, English, EnglishUS, EnglishGB, Dutch, French, German, Italian, Japanese, Korean, Portuguese, PortugueseBrazil, Russian, Spanish, Ukrainian};
            DEFAULT = English;
        }
    }
}

