/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.AIConfiguration;
import ai.api.AIServiceContext;
import ai.api.AIServiceContextBuilder;
import ai.api.AIServiceException;
import ai.api.GsonFactory;
import ai.api.RequestExtras;
import ai.api.http.HttpClient;
import ai.api.model.AIContext;
import ai.api.model.AIRequest;
import ai.api.model.AIResponse;
import ai.api.model.Entity;
import ai.api.model.Status;
import ai.api.util.IOUtils;
import ai.api.util.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIDataService {
    private static final Logger logger = LoggerFactory.getLogger(AIDataService.class);
    private static final AIServiceContext UNDEFINED_SERVICE_CONTEXT = null;
    private static final String REQUEST_METHOD_POST = "POST";
    private static final String REQUEST_METHOD_DELETE = "DELETE";
    private static final String REQUEST_METHOD_GET = "GET";
    private static final String DEFAULT_REQUEST_METHOD = "POST";
    private static final Gson GSON = GsonFactory.getDefaultFactory().getGson();
    private final AIConfiguration config;
    private final AIServiceContext defaultServiceContext;

    public AIDataService(AIConfiguration config, AIServiceContext serviceContext) {
        if (config == null) {
            throw new IllegalArgumentException("config should not be null");
        }
        this.config = config.clone();
        this.defaultServiceContext = serviceContext == null ? new AIServiceContextBuilder().generateSessionId().build() : serviceContext;
    }

    public AIDataService(AIConfiguration config) {
        this(config, null);
    }

    public AIServiceContext getContext() {
        return this.defaultServiceContext;
    }

    public AIResponse request(AIRequest request) throws AIServiceException {
        return this.request(request, (RequestExtras)null);
    }

    public AIResponse request(AIRequest request, AIServiceContext serviceContext) throws AIServiceException {
        return this.request(request, null, serviceContext);
    }

    public AIResponse request(AIRequest request, RequestExtras requestExtras) throws AIServiceException {
        return this.request(request, requestExtras, UNDEFINED_SERVICE_CONTEXT);
    }

    public AIResponse request(AIRequest request, RequestExtras requestExtras, AIServiceContext serviceContext) throws AIServiceException {
        if (request == null) {
            throw new IllegalArgumentException("Request argument must not be null");
        }
        logger.debug("Start request");
        try {
            if (StringUtils.isEmpty(request.getLanguage())) {
                request.setLanguage(this.config.getApiAiLanguage());
            }
            if (StringUtils.isEmpty(request.getSessionId())) {
                request.setSessionId(this.getSessionId(serviceContext));
            }
            if (StringUtils.isEmpty(request.getTimezone())) {
                request.setTimezone(this.getTimeZone(serviceContext));
            }
            Map<String, String> additionalHeaders = null;
            if (requestExtras != null) {
                this.fillRequest(request, requestExtras);
                additionalHeaders = requestExtras.getAdditionalHeaders();
            }
            String queryData = GSON.toJson((Object)request);
            String response = this.doTextRequest(this.config.getQuestionUrl(request.getSessionId()), queryData, additionalHeaders);
            if (StringUtils.isEmpty(response)) {
                throw new AIServiceException("Empty response from ai service. Please check configuration and Internet connection.");
            }
            logger.debug("Response json: " + response.replaceAll("[\r\n]+", " "));
            AIResponse aiResponse = (AIResponse)GSON.fromJson(response, AIResponse.class);
            if (aiResponse == null) {
                throw new AIServiceException("API.AI response parsed as null. Check debug log for details.");
            }
            if (aiResponse.isError()) {
                throw new AIServiceException(aiResponse);
            }
            aiResponse.cleanup();
            return aiResponse;
        }
        catch (MalformedURLException e) {
            logger.error("Malformed url should not be raised", (Throwable)e);
            throw new AIServiceException("Wrong configuration. Please, connect to API.AI Service support", e);
        }
        catch (JsonSyntaxException je) {
            throw new AIServiceException("Wrong service answer format. Please, connect to API.AI Service support", je);
        }
    }

    public AIResponse voiceRequest(InputStream voiceStream) throws AIServiceException {
        return this.voiceRequest(voiceStream, new RequestExtras());
    }

    public AIResponse voiceRequest(InputStream voiceStream, List<AIContext> aiContexts) throws AIServiceException {
        return this.voiceRequest(voiceStream, new RequestExtras(aiContexts, null));
    }

    public AIResponse voiceRequest(InputStream voiceStream, RequestExtras requestExtras) throws AIServiceException {
        return this.voiceRequest(voiceStream, requestExtras, UNDEFINED_SERVICE_CONTEXT);
    }

    public AIResponse voiceRequest(InputStream voiceStream, RequestExtras requestExtras, AIServiceContext serviceContext) throws AIServiceException {
        assert (voiceStream != null);
        logger.debug("Start voice request");
        try {
            AIRequest request = new AIRequest();
            request.setLanguage(this.config.getApiAiLanguage());
            request.setSessionId(this.getSessionId(serviceContext));
            request.setTimezone(this.getTimeZone(serviceContext));
            Map<String, String> additionalHeaders = null;
            if (requestExtras != null) {
                this.fillRequest(request, requestExtras);
                additionalHeaders = requestExtras.getAdditionalHeaders();
            }
            String queryData = GSON.toJson((Object)request);
            logger.debug("Request json: " + queryData);
            String response = this.doSoundRequest(voiceStream, queryData, additionalHeaders);
            if (StringUtils.isEmpty(response)) {
                throw new AIServiceException("Empty response from ai service. Please check configuration.");
            }
            logger.debug("Response json: " + response);
            AIResponse aiResponse = (AIResponse)GSON.fromJson(response, AIResponse.class);
            if (aiResponse == null) {
                throw new AIServiceException("API.AI response parsed as null. Check debug log for details.");
            }
            if (aiResponse.isError()) {
                throw new AIServiceException(aiResponse);
            }
            aiResponse.cleanup();
            return aiResponse;
        }
        catch (MalformedURLException e) {
            logger.error("Malformed url should not be raised", (Throwable)e);
            throw new AIServiceException("Wrong configuration. Please, connect to AI Service support", e);
        }
        catch (JsonSyntaxException je) {
            throw new AIServiceException("Wrong service answer format. Please, connect to API.AI Service support", je);
        }
    }

    @Deprecated
    public boolean resetContexts() {
        AIRequest cleanRequest = new AIRequest();
        cleanRequest.setQuery("empty_query_for_resetting_contexts");
        cleanRequest.setResetContexts(true);
        try {
            AIResponse response = this.request(cleanRequest);
            return !response.isError();
        }
        catch (AIServiceException e) {
            logger.error("Exception while contexts clean.", (Throwable)e);
            return false;
        }
    }

    public List<AIContext> getActiveContexts() throws AIServiceException {
        return this.getActiveContexts(UNDEFINED_SERVICE_CONTEXT);
    }

    public List<AIContext> getActiveContexts(AIServiceContext serviceContext) throws AIServiceException {
        try {
            return (List)this.doRequest((Type)((Object)ApiActiveContextListResponse.class), this.config.getContextsUrl(this.getSessionId(serviceContext)), REQUEST_METHOD_GET);
        }
        catch (BadResponseStatusException e) {
            throw new AIServiceException(e.response);
        }
    }

    public AIContext getActiveContext(String contextName) throws AIServiceException {
        return this.getActiveContext(contextName, UNDEFINED_SERVICE_CONTEXT);
    }

    public AIContext getActiveContext(String contextName, AIServiceContext serviceContext) throws AIServiceException {
        try {
            return (AIContext)this.doRequest((Type)((Object)AIContext.class), this.config.getContextsUrl(this.getSessionId(serviceContext), contextName), REQUEST_METHOD_GET);
        }
        catch (BadResponseStatusException e) {
            if (e.response.getStatus().getCode() == 404) {
                return null;
            }
            throw new AIServiceException(e.response);
        }
    }

    public List<String> addActiveContext(Iterable<AIContext> contexts) throws AIServiceException {
        return this.addActiveContext(contexts, UNDEFINED_SERVICE_CONTEXT);
    }

    public List<String> addActiveContext(Iterable<AIContext> contexts, AIServiceContext serviceContext) throws AIServiceException {
        try {
            ApiActiveContextNamesResponse response = (ApiActiveContextNamesResponse)this.doRequest((Object)contexts, (Type)((Object)ApiActiveContextNamesResponse.class), this.config.getContextsUrl(this.getSessionId(serviceContext)), "POST");
            return response.names;
        }
        catch (BadResponseStatusException e) {
            throw new AIServiceException(e.response);
        }
    }

    public String addActiveContext(AIContext context) throws AIServiceException {
        return this.addActiveContext(context, UNDEFINED_SERVICE_CONTEXT);
    }

    public String addActiveContext(AIContext context, AIServiceContext serviceContext) throws AIServiceException {
        try {
            ApiActiveContextNamesResponse response = (ApiActiveContextNamesResponse)this.doRequest((Object)context, (Type)((Object)ApiActiveContextNamesResponse.class), this.config.getContextsUrl(this.getSessionId(serviceContext)), "POST");
            return response.names != null && response.names.size() > 0 ? response.names.get(0) : null;
        }
        catch (BadResponseStatusException e) {
            throw new AIServiceException(e.response);
        }
    }

    public void resetActiveContexts() throws AIServiceException {
        this.resetActiveContexts(UNDEFINED_SERVICE_CONTEXT);
    }

    public void resetActiveContexts(AIServiceContext serviceContext) throws AIServiceException {
        try {
            this.doRequest((Type)((Object)AIResponse.class), this.config.getContextsUrl(this.getSessionId(serviceContext)), REQUEST_METHOD_DELETE);
        }
        catch (BadResponseStatusException e) {
            throw new AIServiceException(e.response);
        }
    }

    public boolean removeActiveContext(String contextName) throws AIServiceException {
        return this.removeActiveContext(contextName, UNDEFINED_SERVICE_CONTEXT);
    }

    public boolean removeActiveContext(String contextName, AIServiceContext serviceContext) throws AIServiceException {
        try {
            this.doRequest((Type)((Object)AIResponse.class), this.config.getContextsUrl(this.getSessionId(serviceContext), contextName), REQUEST_METHOD_DELETE);
            return true;
        }
        catch (BadResponseStatusException e) {
            if (e.response.getStatus().getCode() == 404) {
                return false;
            }
            throw new AIServiceException(e.response);
        }
    }

    public AIResponse uploadUserEntity(Entity userEntity) throws AIServiceException {
        return this.uploadUserEntity(userEntity, UNDEFINED_SERVICE_CONTEXT);
    }

    public AIResponse uploadUserEntity(Entity userEntity, AIServiceContext serviceContext) throws AIServiceException {
        return this.uploadUserEntities(Collections.singleton(userEntity), serviceContext);
    }

    public AIResponse uploadUserEntities(Collection<Entity> userEntities) throws AIServiceException {
        return this.uploadUserEntities(userEntities, UNDEFINED_SERVICE_CONTEXT);
    }

    public AIResponse uploadUserEntities(Collection<Entity> userEntities, AIServiceContext serviceContext) throws AIServiceException {
        if (userEntities == null || userEntities.size() == 0) {
            throw new AIServiceException("Empty entities list");
        }
        String requestData = GSON.toJson(userEntities);
        try {
            String response = this.doTextRequest(this.config.getUserEntitiesEndpoint(this.getSessionId(serviceContext)), requestData);
            if (StringUtils.isEmpty(response)) {
                throw new AIServiceException("Empty response from ai service. Please check configuration and Internet connection.");
            }
            logger.debug("Response json: " + response);
            AIResponse aiResponse = (AIResponse)GSON.fromJson(response, AIResponse.class);
            if (aiResponse == null) {
                throw new AIServiceException("API.AI response parsed as null. Check debug log for details.");
            }
            if (aiResponse.isError()) {
                throw new AIServiceException(aiResponse);
            }
            aiResponse.cleanup();
            return aiResponse;
        }
        catch (MalformedURLException e) {
            logger.error("Malformed url should not be raised", (Throwable)e);
            throw new AIServiceException("Wrong configuration. Please, connect to AI Service support", e);
        }
        catch (JsonSyntaxException je) {
            throw new AIServiceException("Wrong service answer format. Please, connect to API.AI Service support", je);
        }
    }

    protected String doTextRequest(String requestJson, AIServiceContext serviceContext) throws MalformedURLException, AIServiceException {
        return this.doTextRequest(this.config.getQuestionUrl(this.getSessionId(serviceContext)), requestJson);
    }

    protected String doTextRequest(String requestJson) throws MalformedURLException, AIServiceException {
        return this.doTextRequest(requestJson, UNDEFINED_SERVICE_CONTEXT);
    }

    protected String doTextRequest(String endpoint, String requestJson) throws MalformedURLException, AIServiceException {
        return this.doTextRequest(endpoint, requestJson, null);
    }

    protected String doTextRequest(String endpoint, String requestJson, Map<String, String> additionalHeaders) throws MalformedURLException, AIServiceException {
        assert (endpoint != null);
        assert (requestJson != null);
        HttpURLConnection connection = null;
        try {
            URL url = new URL(endpoint);
            String queryData = requestJson;
            logger.debug("Request json: " + queryData);
            connection = this.config.getProxy() != null ? (HttpURLConnection)url.openConnection(this.config.getProxy()) : (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.addRequestProperty("Authorization", "Bearer " + this.config.getApiKey());
            connection.addRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.addRequestProperty("Accept", "application/json");
            if (additionalHeaders != null) {
                for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                    connection.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.connect();
            BufferedOutputStream outputStream = new BufferedOutputStream(connection.getOutputStream());
            IOUtils.writeAll(queryData, outputStream);
            outputStream.close();
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            String response = IOUtils.readAll(inputStream);
            ((InputStream)inputStream).close();
            String string = response;
            return string;
        }
        catch (IOException e) {
            if (connection != null) {
                block15: {
                    InputStream errorStream = connection.getErrorStream();
                    if (errorStream == null) break block15;
                    String errorString = IOUtils.readAll(errorStream);
                    logger.debug(errorString);
                    String string = errorString;
                    return string;
                }
                try {
                    throw new AIServiceException("Can't connect to the api.ai service.", e);
                }
                catch (IOException ex) {
                    logger.warn("Can't read error response", (Throwable)ex);
                }
            }
            logger.error("Can't make request to the API.AI service. Please, check connection settings and API access token.", (Throwable)e);
            throw new AIServiceException("Can't make request to the API.AI service. Please, check connection settings and API access token.", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected String doSoundRequest(InputStream voiceStream, String queryData) throws MalformedURLException, AIServiceException {
        return this.doSoundRequest(voiceStream, queryData, null, UNDEFINED_SERVICE_CONTEXT);
    }

    protected String doSoundRequest(InputStream voiceStream, String queryData, Map<String, String> additionalHeaders) throws MalformedURLException, AIServiceException {
        return this.doSoundRequest(voiceStream, queryData, additionalHeaders, UNDEFINED_SERVICE_CONTEXT);
    }

    protected String doSoundRequest(InputStream voiceStream, String queryData, Map<String, String> additionalHeaders, AIServiceContext serviceContext) throws MalformedURLException, AIServiceException {
        assert (voiceStream != null);
        assert (queryData != null);
        HttpURLConnection connection = null;
        HttpClient httpClient = null;
        try {
            String response;
            URL url = new URL(this.config.getQuestionUrl(this.getSessionId(serviceContext)));
            logger.debug("Connecting to {}", (Object)url);
            connection = this.config.getProxy() != null ? (HttpURLConnection)url.openConnection(this.config.getProxy()) : (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("Authorization", "Bearer " + this.config.getApiKey());
            connection.addRequestProperty("Accept", "application/json");
            if (additionalHeaders != null) {
                for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                    connection.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            httpClient = new HttpClient(connection);
            httpClient.setWriteSoundLog(this.config.isWriteSoundLog());
            httpClient.connectForMultipart();
            httpClient.addFormPart("request", queryData);
            httpClient.addFilePart("voiceData", "voice.wav", voiceStream);
            httpClient.finishMultipart();
            String string = response = httpClient.getResponse();
            return string;
        }
        catch (IOException e) {
            if (httpClient != null) {
                String errorString = httpClient.getErrorString();
                logger.debug(errorString);
                if (!StringUtils.isEmpty(errorString)) {
                    String string = errorString;
                    return string;
                }
                if (e instanceof HttpRetryException) {
                    AIResponse aIResponse = new AIResponse();
                    int code = ((HttpRetryException)e).responseCode();
                    Status status = Status.fromResponseCode(code);
                    status.setErrorDetails(((HttpRetryException)e).getReason());
                    aIResponse.setStatus(status);
                    throw new AIServiceException(aIResponse);
                }
            }
            logger.error("Can't make request to the API.AI service. Please, check connection settings and API.AI keys.", (Throwable)e);
            throw new AIServiceException("Can't make request to the API.AI service. Please, check connection settings and API.AI keys.", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected <TResponse> TResponse doRequest(Type responseType, String endpoint, String method) throws AIServiceException, BadResponseStatusException {
        return this.doRequest(responseType, endpoint, method, (Map<String, String>)null);
    }

    protected <TRequest, TResponse> TResponse doRequest(TRequest request, Type responseType, String endpoint, String method) throws AIServiceException, BadResponseStatusException {
        return this.doRequest(request, responseType, endpoint, method, null);
    }

    protected <TResponse> TResponse doRequest(Type responseType, String endpoint, String method, Map<String, String> additionalHeaders) throws AIServiceException, BadResponseStatusException {
        return this.doRequest(null, responseType, endpoint, method, additionalHeaders);
    }

    protected <TRequest, TResponse> TResponse doRequest(TRequest request, Type responseType, String endpoint, String method, Map<String, String> additionalHeaders) throws AIServiceException, BadResponseStatusException {
        assert (endpoint != null);
        HttpURLConnection connection = null;
        try {
            URL url = new URL(endpoint);
            String queryData = request != null ? GSON.toJson(request) : null;
            String requestMethod = method != null ? method : "POST";
            logger.debug("Request json: " + queryData);
            connection = this.config.getProxy() != null ? (HttpURLConnection)url.openConnection(this.config.getProxy()) : (HttpURLConnection)url.openConnection();
            if (queryData != null && !"POST".equals(requestMethod)) {
                throw new AIServiceException("Non-empty request should be sent using POST method");
            }
            connection.setRequestMethod(requestMethod);
            if ("POST".equals(requestMethod)) {
                connection.setDoOutput(true);
            }
            connection.addRequestProperty("Authorization", "Bearer " + this.config.getApiKey());
            connection.addRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.addRequestProperty("Accept", "application/json");
            if (additionalHeaders != null) {
                for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                    connection.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.connect();
            if (queryData != null) {
                BufferedOutputStream outputStream = new BufferedOutputStream(connection.getOutputStream());
                IOUtils.writeAll(queryData, outputStream);
                outputStream.close();
            }
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            String response = IOUtils.readAll(inputStream);
            ((InputStream)inputStream).close();
            try {
                AIResponse aiResponse = (AIResponse)GSON.fromJson(response, AIResponse.class);
                if (aiResponse.getStatus() != null && aiResponse.getStatus().getCode() != 200) {
                    throw new BadResponseStatusException(aiResponse);
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
            Object object = GSON.fromJson(response, responseType);
            return (TResponse)object;
        }
        catch (IOException e) {
            if (connection != null) {
                try {
                    InputStream errorStream = connection.getErrorStream();
                    if (errorStream != null) {
                        String errorString = IOUtils.readAll(errorStream);
                        logger.debug(errorString);
                        throw new AIServiceException(errorString, e);
                    }
                    throw new AIServiceException("Can't connect to the api.ai service.", e);
                }
                catch (IOException ex) {
                    logger.warn("Can't read error response", (Throwable)ex);
                }
            }
            logger.error("Can't make request to the API.AI service. Please, check connection settings and API access token.", (Throwable)e);
            throw new AIServiceException("Can't make request to the API.AI service. Please, check connection settings and API access token.", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void fillRequest(AIRequest request, RequestExtras requestExtras) {
        assert (request != null);
        assert (requestExtras != null);
        if (requestExtras.hasContexts()) {
            request.setContexts(requestExtras.getContexts());
        }
        if (requestExtras.hasEntities()) {
            request.setEntities(requestExtras.getEntities());
        }
        if (requestExtras.getLocation() != null) {
            request.setLocation(requestExtras.getLocation());
        }
    }

    private String getSessionId(AIServiceContext serviceContext) {
        return serviceContext != null ? serviceContext.getSessionId() : this.defaultServiceContext.getSessionId();
    }

    private String getTimeZone(AIServiceContext serviceContext) {
        TimeZone timeZone = serviceContext != null ? serviceContext.getTimeZone() : this.defaultServiceContext.getTimeZone();
        return (timeZone != null ? timeZone : Calendar.getInstance().getTimeZone()).getID();
    }

    private static class BadResponseStatusException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final AIResponse response;

        public BadResponseStatusException(AIResponse response) {
            this.response = response;
        }
    }

    private static interface ApiActiveContextListResponse
    extends List<AIContext> {
    }

    private static class ApiActiveContextNamesResponse
    extends AIResponse {
        private static final long serialVersionUID = 1L;
        public List<String> names;

        private ApiActiveContextNamesResponse() {
        }
    }
}

