/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.model.ResponseMessage;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class GsonFactory {
    private static final Gson DEFAULT_GSON = new GsonBuilder().create();
    private static final Gson PROTOCOL_GSON = new GsonBuilder().setDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US).toPattern()).registerTypeAdapter(ResponseMessage.class, (Object)new ResponseItemAdapter()).registerTypeAdapter(ResponseMessage.MessageType.class, (Object)new ResponseMessageTypeAdapter()).registerTypeAdapter(ResponseMessage.Platform.class, (Object)new ResponseMessagePlatformAdapter()).registerTypeAdapter(ResponseMessage.ResponseSpeech.class, (Object)new ResponseSpeechDeserializer()).create();
    private static final GsonFactory DEFAULT_FACTORY = new GsonFactory();

    public Gson getGson() {
        return PROTOCOL_GSON;
    }

    public static GsonFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    private static class ResponseSpeechDeserializer
    implements JsonDeserializer<ResponseMessage> {
        private ResponseSpeechDeserializer() {
        }

        public ResponseMessage.ResponseSpeech deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && ((JsonObject)json).get("speech").isJsonPrimitive()) {
                JsonArray array = new JsonArray();
                array.add(((JsonObject)json).get("speech"));
                ((JsonObject)json).add("speech", (JsonElement)array);
            }
            return (ResponseMessage.ResponseSpeech)DEFAULT_GSON.fromJson(json, typeOfT);
        }
    }

    private static class ResponseItemAdapter
    implements JsonDeserializer<ResponseMessage>,
    JsonSerializer<ResponseMessage> {
        private ResponseItemAdapter() {
        }

        public ResponseMessage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ResponseMessage.MessageType messageType = (ResponseMessage.MessageType)((Object)context.deserialize(json.getAsJsonObject().get("type"), ResponseMessage.MessageType.class));
            return (ResponseMessage)context.deserialize(json, messageType.getType());
        }

        public JsonElement serialize(ResponseMessage src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src, src.getClass());
        }
    }

    private static class ResponseMessageTypeAdapter
    implements JsonDeserializer<ResponseMessage.MessageType>,
    JsonSerializer<ResponseMessage.MessageType> {
        private ResponseMessageTypeAdapter() {
        }

        public JsonElement serialize(ResponseMessage.MessageType src, Type typeOfT, JsonSerializationContext context) {
            return context.serialize(src.getCode() <= 4 ? Integer.valueOf(src.getCode()) : src.getName());
        }

        public ResponseMessage.MessageType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonPrimitive jsonValue = json.getAsJsonPrimitive();
            ResponseMessage.MessageType result = null;
            result = jsonValue.isNumber() ? ResponseMessage.MessageType.fromCode(jsonValue.getAsInt()) : ResponseMessage.MessageType.fromName(jsonValue.getAsString());
            if (result == null) {
                throw new JsonParseException(String.format("Unexpected message type value: %s", jsonValue));
            }
            return result;
        }
    }

    private static class ResponseMessagePlatformAdapter
    implements JsonDeserializer<ResponseMessage.Platform>,
    JsonSerializer<ResponseMessage.Platform> {
        private ResponseMessagePlatformAdapter() {
        }

        public JsonElement serialize(ResponseMessage.Platform src, Type typeOfT, JsonSerializationContext context) {
            return context.serialize((Object)src.getName());
        }

        public ResponseMessage.Platform deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsString();
            if (name == null) {
                return ResponseMessage.Platform.DEFAULT;
            }
            ResponseMessage.Platform result = ResponseMessage.Platform.fromName(name);
            if (result == null) {
                throw new JsonParseException(String.format("Unexpected platform name: %s", json));
            }
            return result;
        }
    }
}

