/*
 * Decompiled with CFR 0.152.
 */
package ai.api.model;

import ai.api.model.GoogleAssistantResponseMessages;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ResponseMessage {
    @Expose
    private final MessageType type;
    @Expose
    private final Platform platform;

    protected ResponseMessage(MessageType type) {
        this(type, null);
    }

    protected ResponseMessage(MessageType type, Platform platform) {
        assert (type != null);
        this.type = type;
        this.platform = platform != null ? platform : Platform.DEFAULT;
    }

    public static class ResponsePayload
    extends ResponseMessage {
        @Expose
        private JsonObject payload;

        public ResponsePayload() {
            super(MessageType.PAYLOAD);
        }

        public JsonObject getPayload() {
            return this.payload;
        }

        public void setPayload(JsonObject payload) {
            this.payload = payload;
        }
    }

    public static class ResponseImage
    extends ResponseMessage {
        @Expose
        private String imageUrl;

        public ResponseImage() {
            super(MessageType.IMAGE);
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }
    }

    public static class ResponseQuickReply
    extends ResponseMessage {
        @Expose
        private String title;
        @Expose
        private List<String> replies;

        public ResponseQuickReply() {
            super(MessageType.QUICK_REPLY);
        }

        public List<String> getReplies() {
            return this.replies;
        }

        public void setReplies(List<String> replies) {
            this.replies = replies;
        }

        public void setReplies(String ... replies) {
            this.setReplies(Arrays.asList(replies));
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class ResponseCard
    extends ResponseMessage {
        @Expose
        private String title;
        @Expose
        private String subtitle;
        @Expose
        private String imageUrl;
        @Expose
        private List<Button> buttons;

        public ResponseCard() {
            super(MessageType.CARD);
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public List<Button> getButtons() {
            return this.buttons;
        }

        public void setButtons(List<Button> buttons) {
            this.buttons = buttons;
        }

        public void setButtons(Button ... buttons) {
            this.setButtons(Arrays.asList(buttons));
        }

        public static class Button {
            @Expose
            private String text;
            @Expose
            private String postback;

            public Button(String text, String postback) {
                this.text = text;
                this.postback = postback;
            }

            public void setText(String text) {
                this.text = text;
            }

            public String getText() {
                return this.text;
            }

            public void setPostback(String postback) {
                this.postback = postback;
            }

            public String getPostback() {
                return this.postback;
            }
        }
    }

    public static class ResponseSpeech
    extends ResponseMessage {
        @Expose
        public List<String> speech;

        public ResponseSpeech() {
            super(MessageType.SPEECH);
        }

        public List<String> getSpeech() {
            return this.speech;
        }

        public void setSpeech(List<String> speech) {
            this.speech = speech;
        }

        public void setSpeech(String ... speech) {
            this.setSpeech(Arrays.asList(speech));
        }
    }

    public static enum Platform {
        DEFAULT(null),
        GOOGLE("google"),
        FACEBOOK("facebook"),
        SLACK("slack"),
        TELEGRAM("telegram"),
        KIK("kik"),
        VIBER("viber"),
        SKYPE("skype"),
        LINE("line");

        private final String name;
        private static Map<String, Platform> platformByName;

        private Platform(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Platform fromName(String name) {
            return platformByName.get(name != null ? name.toLowerCase() : null);
        }

        static {
            platformByName = new HashMap<String, Platform>();
            for (Platform platform : Platform.values()) {
                String platformName = platform.getName();
                platformByName.put(platformName != null ? platformName.toLowerCase() : null, platform);
            }
        }
    }

    public static final class MessageType
    extends Enum<MessageType> {
        public static final /* enum */ MessageType SPEECH = new MessageType(0, "message", (Type)((Object)ResponseSpeech.class));
        public static final /* enum */ MessageType CARD = new MessageType(1, "card", (Type)((Object)ResponseCard.class));
        public static final /* enum */ MessageType QUICK_REPLY = new MessageType(2, "quick_reply", (Type)((Object)ResponseQuickReply.class));
        public static final /* enum */ MessageType IMAGE = new MessageType(3, "image", (Type)((Object)ResponseImage.class));
        public static final /* enum */ MessageType PAYLOAD = new MessageType(4, "custom_payload", (Type)((Object)ResponsePayload.class));
        public static final /* enum */ MessageType CHAT_BUBBLE = new MessageType(5, "simple_response", (Type)((Object)GoogleAssistantResponseMessages.ResponseChatBubble.class));
        public static final /* enum */ MessageType BASIC_CARD = new MessageType(6, "basic_card", (Type)((Object)GoogleAssistantResponseMessages.ResponseBasicCard.class));
        public static final /* enum */ MessageType LIST_CARD = new MessageType(7, "list_card", (Type)((Object)GoogleAssistantResponseMessages.ResponseListCard.class));
        public static final /* enum */ MessageType SUGGESTION_CHIPS = new MessageType(8, "suggestion_chips", (Type)((Object)GoogleAssistantResponseMessages.ResponseSuggestionChips.class));
        public static final /* enum */ MessageType CAROUSEL_CARD = new MessageType(9, "carousel_card", (Type)((Object)GoogleAssistantResponseMessages.ResponseCarouselCard.class));
        public static final /* enum */ MessageType LINK_OUT_CHIP = new MessageType(10, "link_out_chip", (Type)((Object)GoogleAssistantResponseMessages.ResponseLinkOutChip.class));
        private final int code;
        private final String name;
        private final Type type;
        private static Map<Integer, MessageType> typeByCode;
        private static Map<String, MessageType> typeByName;
        private static final /* synthetic */ MessageType[] $VALUES;

        public static MessageType[] values() {
            return (MessageType[])$VALUES.clone();
        }

        public static MessageType valueOf(String name) {
            return Enum.valueOf(MessageType.class, name);
        }

        private MessageType(int code, String name, Type curClass) {
            assert (name != null);
            assert (curClass != null);
            this.code = code;
            this.name = name;
            this.type = curClass;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public static MessageType fromCode(int code) {
            return typeByCode.get(code);
        }

        public static MessageType fromName(String name) {
            return typeByName.get(name != null ? name.toLowerCase() : null);
        }

        static {
            $VALUES = new MessageType[]{SPEECH, CARD, QUICK_REPLY, IMAGE, PAYLOAD, CHAT_BUBBLE, BASIC_CARD, LIST_CARD, SUGGESTION_CHIPS, CAROUSEL_CARD, LINK_OUT_CHIP};
            typeByCode = new HashMap<Integer, MessageType>();
            typeByName = new HashMap<String, MessageType>();
            for (MessageType type : MessageType.values()) {
                typeByCode.put(type.code, type);
                typeByName.put(type.name.toLowerCase(), type);
            }
        }
    }
}

