/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.GsonFactory;
import ai.api.SpeaktoitRecognitionRequest;
import ai.api.http.HttpClient;
import ai.api.model.QuestionMetadata;
import android.os.AsyncTask;
import android.util.Log;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class SpeaktoitRecognitionRequestTask
extends AsyncTask<SpeaktoitRecognitionRequest, Integer, String> {
    public static final String TAG = SpeaktoitRecognitionRequestTask.class.getName();
    private final URL url;

    public SpeaktoitRecognitionRequestTask(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doInBackground(SpeaktoitRecognitionRequest ... params) {
        SpeaktoitRecognitionRequest speaktoitRequest = params[0];
        byte[] soundData = speaktoitRequest.getSoundData();
        QuestionMetadata metadata = speaktoitRequest.getMetadata();
        String metadataString = GsonFactory.getGson().toJson((Object)metadata);
        HttpURLConnection connection = null;
        try {
            String response;
            connection = (HttpURLConnection)this.url.openConnection();
            HttpClient httpClient = new HttpClient(connection);
            httpClient.connectForMultipart();
            httpClient.addFilePart("sound", "sound.wav", soundData);
            httpClient.addFormPart("metadata", metadataString);
            httpClient.finishMultipart();
            String string = response = httpClient.getResponse();
            return string;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Can't make request to the Speaktoit AI service. Please, check connection settings and API access token.", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }
}

