/*
 * Decompiled with CFR 0.152.
 */
package ai.api.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;

public class HttpClient {
    private HttpURLConnection con;
    private OutputStream os;
    private final String delimiter = "--";
    private final String boundary = "SwA" + Long.toString(System.currentTimeMillis()) + "SwA";

    public HttpClient(HttpURLConnection con) {
        this.con = con;
    }

    public void connectForMultipart() throws IOException {
        this.con.setRequestMethod("POST");
        this.con.setDoInput(true);
        this.con.setDoOutput(true);
        this.con.setRequestProperty("Connection", "Keep-Alive");
        this.con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.con.connect();
        this.os = this.con.getOutputStream();
    }

    public void addFormPart(String paramName, String value) throws IOException {
        this.os.write(("--" + this.boundary + "\r\n").getBytes());
        this.os.write("Content-Type: text/plain\r\n".getBytes());
        this.os.write(("Content-Disposition: form-data; name=\"" + paramName + "\"\r\n").getBytes());
        this.os.write(("\r\n" + value + "\r\n").getBytes());
    }

    public void addFilePart(String paramName, String fileName, byte[] data) throws IOException {
        this.os.write(("--" + this.boundary + "\r\n").getBytes());
        this.os.write(("Content-Disposition: form-data; name=\"" + paramName + "\"; filename=\"" + fileName + "\"\r\n").getBytes());
        this.os.write("Content-Type: application/octet-stream\r\n".getBytes());
        this.os.write("Content-Transfer-Encoding: binary\r\n".getBytes());
        this.os.write("\r\n".getBytes());
        this.os.write(data);
        this.os.write("\r\n".getBytes());
    }

    public void finishMultipart() throws IOException {
        this.os.write(("--" + this.boundary + "--" + "\r\n").getBytes());
    }

    public String getResponse() throws IOException {
        InputStream is = this.con.getInputStream();
        byte[] b1 = new byte[1024];
        StringBuilder buffer = new StringBuilder();
        while (is.read(b1) != -1) {
            buffer.append(new String(b1));
        }
        this.con.disconnect();
        return buffer.toString();
    }
}

