/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

public class AIConfiguration {
    private static final String SERVICE_PROD_URL = "https://api.api.ai/v1/";
    private static final String SERVICE_DEV_URL = "https://dev.api.ai/api/";
    protected static String PROTOCOL_VERSION = "v1";
    protected static final String QUESTION_ENDPOINT = "query";
    private String serviceUrl;
    private String apiKey;
    private final String subscriptionKey;
    private String language;
    private RecognitionEngine recognitionEngine;
    private boolean debug;
    private boolean writeSoundLog;

    public AIConfiguration(String apiKey, String subscriptionKey, SupportedLanguages language, RecognitionEngine recognitionEngine) {
        this.apiKey = apiKey;
        this.subscriptionKey = subscriptionKey;
        this.language = language.languageTag;
        this.recognitionEngine = recognitionEngine;
        this.serviceUrl = SERVICE_PROD_URL;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getSubscriptionKey() {
        return this.subscriptionKey;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public RecognitionEngine getRecognitionEngine() {
        return this.recognitionEngine;
    }

    public void setRecognitionEngine(RecognitionEngine recognitionEngine) {
        this.recognitionEngine = recognitionEngine;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.serviceUrl = debug ? SERVICE_DEV_URL : SERVICE_PROD_URL;
    }

    public void setWriteSoundLog(boolean writeSoundLog) {
        this.writeSoundLog = writeSoundLog;
    }

    public boolean isWriteSoundLog() {
        return this.writeSoundLog;
    }

    public String getQuestionUrl() {
        return String.format("%s%s", this.serviceUrl, QUESTION_ENDPOINT);
    }

    public static enum SupportedLanguages {
        English("en"),
        Russian("ru"),
        German("de"),
        Portuguese("pt");

        private final String languageTag;

        private SupportedLanguages(String languageTag) {
            this.languageTag = languageTag;
        }
    }

    public static enum RecognitionEngine {
        Google,
        Speaktoit;

    }
}

