/*
 * Decompiled with CFR 0.152.
 */
package ai.api.util;

import ai.api.util.PartialDate;
import android.text.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public abstract class ParametersConverter {
    public static final String PROTOCOL_DATE_FORMAT = "yyyy-MM-dd";
    public static final String PROTOCOL_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String PROTOCOL_TIME_FORMAT = "HH:mm:ss";

    public static Date parseDateTime(String parameter) throws ParseException {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(PROTOCOL_DATE_TIME_FORMAT, Locale.US);
        return dateTimeFormat.parse(parameter);
    }

    public static Date parseDate(String parameter) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(PROTOCOL_DATE_FORMAT, Locale.US);
        return dateFormat.parse(parameter);
    }

    public static Date parseTime(String parameter) throws ParseException {
        SimpleDateFormat timeFormat = new SimpleDateFormat(PROTOCOL_TIME_FORMAT, Locale.US);
        Date timeParameter = timeFormat.parse(parameter);
        Calendar taskDueDate = Calendar.getInstance();
        taskDueDate.set(11, timeParameter.getHours());
        taskDueDate.set(12, timeParameter.getMinutes());
        taskDueDate.set(13, timeParameter.getSeconds());
        return taskDueDate.getTime();
    }

    public static PartialDate parsePartialDate(String parameter) throws ParseException {
        if (TextUtils.isEmpty((CharSequence)parameter)) {
            throw new IllegalArgumentException("parameter must not be empty");
        }
        if (parameter.contains("u")) {
            String[] parts = parameter.split("-");
            if (parts.length != 3) {
                throw new ParseException(String.format("Partial date must have 3 parts, but have %s: %s", parts.length, parameter), 0);
            }
            Integer year = ParametersConverter.parsePart(parts[0]);
            Integer month = ParametersConverter.parsePart(parts[1]);
            Integer day = ParametersConverter.parsePart(parts[2]);
            PartialDate result = new PartialDate();
            result.set(1, year);
            result.set(2, month);
            result.set(5, day);
            return result;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(PROTOCOL_DATE_FORMAT, Locale.US);
        Date date = dateFormat.parse(parameter);
        return new PartialDate(date);
    }

    private static Integer parsePart(String part) {
        if (part.contains("u")) {
            return PartialDate.UNSPECIFIED_VALUE;
        }
        return Integer.parseInt(part);
    }

    public static int parseInteger(String parameter) {
        return Integer.parseInt(parameter);
    }

    public static float parseFloat(String parameter) {
        return Float.parseFloat(parameter);
    }
}

