/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.AIConfiguration;
import ai.api.AIDataService;
import ai.api.AIListener;
import ai.api.AIServiceException;
import ai.api.GoogleRecognitionServiceImpl;
import ai.api.SpeaktoitRecognitionServiceImpl;
import ai.api.model.AIContext;
import ai.api.model.AIError;
import ai.api.model.AIRequest;
import ai.api.model.AIResponse;
import android.content.Context;
import java.util.List;

public abstract class AIService {
    private static final String TAG = AIService.class.getName();
    protected final AIConfiguration config;
    protected final Context context;
    protected final AIDataService aiDataService;
    private AIListener listener;

    public static AIService getService(Context context, AIConfiguration config) {
        if (config.getRecognitionEngine() == AIConfiguration.RecognitionEngine.Google) {
            return new GoogleRecognitionServiceImpl(context, config);
        }
        if (config.getRecognitionEngine() == AIConfiguration.RecognitionEngine.System) {
            return new GoogleRecognitionServiceImpl(context, config);
        }
        if (config.getRecognitionEngine() == AIConfiguration.RecognitionEngine.Speaktoit) {
            return new SpeaktoitRecognitionServiceImpl(context, config);
        }
        throw new UnsupportedOperationException("This engine still not supported");
    }

    protected AIService(AIConfiguration config, Context context) {
        this.config = config;
        this.context = context;
        this.aiDataService = new AIDataService(context, config);
    }

    public abstract void startListening();

    public abstract void startListening(List<AIContext> var1);

    public abstract void stopListening();

    public abstract void cancel();

    public void setListener(AIListener listener) {
        this.listener = listener;
    }

    protected void onResult(AIResponse response) {
        if (this.listener != null) {
            this.listener.onResult(response);
        }
    }

    protected void onError(AIError error) {
        if (this.listener != null) {
            this.listener.onError(error);
        }
    }

    protected void onAudioLevelChanged(float audioLevel) {
        if (this.listener != null) {
            this.listener.onAudioLevel(audioLevel);
        }
    }

    protected void onListeningStarted() {
        if (this.listener != null) {
            this.listener.onListeningStarted();
        }
    }

    protected void onListeningFinished() {
        if (this.listener != null) {
            this.listener.onListeningFinished();
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public AIResponse textRequest(AIRequest request) throws AIServiceException {
        return this.aiDataService.request(request);
    }

    public boolean resetContexts() {
        return this.aiDataService.resetContexts();
    }
}

