/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.AIConfiguration;
import ai.api.AIService;
import ai.api.AIServiceException;
import ai.api.model.AIContext;
import ai.api.model.AIError;
import ai.api.model.AIResponse;
import ai.api.util.VoiceActivityDetector;
import android.content.Context;
import android.media.AudioRecord;
import android.os.AsyncTask;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SpeaktoitRecognitionServiceImpl
extends AIService {
    public static final String TAG = SpeaktoitRecognitionServiceImpl.class.getName();
    private static final int SAMPLE_RATE_IN_HZ = 16000;
    private static final int CHANNEL_CONFIG = 16;
    private static final int AUDIO_FORMAT = 2;
    private AudioRecord mediaRecorder;
    private final Object mediaRecorderLock = new Object();
    private final ExecutorService eventsExecutor = Executors.newSingleThreadExecutor();
    private volatile boolean isRecording = false;
    private final VoiceActivityDetector voiceActivityDetector = new VoiceActivityDetector(16000);

    protected SpeaktoitRecognitionServiceImpl(Context context, AIConfiguration config) {
        super(config, context);
        this.initMediaRecorder();
    }

    private void initMediaRecorder() {
        int minBufferSize = AudioRecord.getMinBufferSize((int)16000, (int)16, (int)2);
        this.mediaRecorder = new AudioRecord(1, 16000, 16, 2, minBufferSize);
        this.voiceActivityDetector.setMinAudioBufferSize(minBufferSize);
        this.voiceActivityDetector.setSpeechListener(new VoiceActivityDetector.SpeechEventsListener(){

            @Override
            public void onSpeechBegin() {
                Log.v((String)TAG, (String)"onSpeechBegin event");
            }

            @Override
            public void onSpeechEnd() {
                Log.v((String)TAG, (String)"onSpeechEnd event");
                SpeaktoitRecognitionServiceImpl.this.eventsExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        SpeaktoitRecognitionServiceImpl.this.stopListening();
                    }
                });
            }

            @Override
            public void onAudioLevelChanged(double energy) {
                SpeaktoitRecognitionServiceImpl.this.onAudioLevelChanged((float)energy);
            }
        });
    }

    @Override
    public void startListening() {
        this.startListening(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startListening(List<AIContext> contexts) {
        Log.v((String)TAG, (String)"startListening");
        Object object = this.mediaRecorderLock;
        synchronized (object) {
            if (!this.isRecording) {
                this.voiceActivityDetector.reset();
                this.mediaRecorder.startRecording();
                this.isRecording = true;
                this.onListeningStarted();
                new RequestTask(new RecorderWrapper(this.mediaRecorder), contexts).execute(new Void[0]);
            } else {
                Log.w((String)TAG, (String)"Trying start listening when it already active");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopListening() {
        Log.v((String)TAG, (String)"stopListening");
        Object object = this.mediaRecorderLock;
        synchronized (object) {
            if (this.isRecording) {
                try {
                    this.mediaRecorder.stop();
                    this.isRecording = false;
                    this.onListeningFinished();
                }
                catch (IllegalStateException e) {
                    Log.w((String)TAG, (String)"Attempt to stop mediaRecorder when it is stopped");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.mediaRecorderLock;
        synchronized (object) {
            if (this.isRecording) {
                this.mediaRecorder.stop();
                this.isRecording = false;
                this.onListeningFinished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        super.pause();
        Object object = this.mediaRecorderLock;
        synchronized (object) {
            if (this.isRecording) {
                this.mediaRecorder.stop();
                this.isRecording = false;
            }
            this.mediaRecorder.release();
            this.mediaRecorder = null;
        }
    }

    @Override
    public void resume() {
        super.resume();
        if (this.mediaRecorder == null) {
            this.initMediaRecorder();
        }
    }

    private class RequestTask
    extends AsyncTask<Void, Void, AIResponse> {
        private final RecorderWrapper recorderWrapper;
        private final List<AIContext> contexts;
        private AIError aiError;

        private RequestTask(RecorderWrapper recorderWrapper) {
            this.recorderWrapper = recorderWrapper;
            this.contexts = null;
        }

        private RequestTask(RecorderWrapper recorderWrapper, List<AIContext> contexts) {
            this.recorderWrapper = recorderWrapper;
            this.contexts = contexts;
        }

        protected AIResponse doInBackground(Void ... params) {
            try {
                AIResponse aiResponse = SpeaktoitRecognitionServiceImpl.this.aiDataService.voiceRequest(this.recorderWrapper, this.contexts);
                return aiResponse;
            }
            catch (AIServiceException e) {
                this.aiError = new AIError("Wrong answer from server " + e.toString());
                return null;
            }
        }

        protected void onPostExecute(AIResponse aiResponse) {
            super.onPostExecute((Object)aiResponse);
            if (aiResponse != null) {
                SpeaktoitRecognitionServiceImpl.this.onResult(aiResponse);
            } else {
                SpeaktoitRecognitionServiceImpl.this.onError(this.aiError);
            }
        }
    }

    private class RecorderWrapper
    extends InputStream {
        private final AudioRecord audioRecord;

        private RecorderWrapper(AudioRecord audioRecord) {
            this.audioRecord = audioRecord;
        }

        @Override
        public int read() throws IOException {
            byte[] buffer = new byte[1];
            this.audioRecord.read(buffer, 0, 1);
            return buffer[0];
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            int bytesRead = this.audioRecord.read(buffer, byteOffset, byteCount);
            if (bytesRead > 0) {
                SpeaktoitRecognitionServiceImpl.this.voiceActivityDetector.processBuffer(buffer, bytesRead);
            }
            return bytesRead;
        }
    }
}

