/*
 * Decompiled with CFR 0.152.
 */
package ai.api.ui;

import ai.api.AIConfiguration;
import ai.api.AIServiceException;
import ai.api.PartialResultsListener;
import ai.api.R;
import ai.api.model.AIError;
import ai.api.model.AIRequest;
import ai.api.model.AIResponse;
import ai.api.ui.AIButton;
import android.app.Dialog;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.widget.TextView;
import java.util.List;

public class AIDialog {
    private static final String TAG = AIDialog.class.getName();
    private final Context context;
    private final AIConfiguration config;
    private AIDialogListener resultsListener;
    private final Dialog dialog;
    private final AIButton aiButton;
    private final TextView partialResultsTextView;
    private final Handler handler;

    public AIDialog(Context context, AIConfiguration config) {
        this(context, config, R.layout.aidialog);
    }

    public AIDialog(Context context, AIConfiguration config, int customLayout) {
        this.context = context;
        this.config = config;
        this.dialog = new Dialog(context);
        this.handler = new Handler(Looper.getMainLooper());
        this.dialog.setCanceledOnTouchOutside(true);
        this.dialog.requestWindowFeature(1);
        this.dialog.setContentView(customLayout);
        this.partialResultsTextView = (TextView)this.dialog.findViewById(R.id.partialResultsTextView);
        this.aiButton = (AIButton)this.dialog.findViewById(R.id.micButton);
        this.aiButton.initialize(config);
        this.setAIButtonCallback(this.aiButton);
    }

    public void setResultsListener(AIDialogListener resultsListener) {
        this.resultsListener = resultsListener;
    }

    public void showAndListen() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                AIDialog.this.resetControls();
                AIDialog.this.dialog.show();
                AIDialog.this.startListening();
            }
        });
    }

    public AIResponse textRequest(AIRequest request) throws AIServiceException {
        return this.aiButton.textRequest(request);
    }

    public AIResponse textRequest(String request) throws AIServiceException {
        return this.textRequest(new AIRequest(request));
    }

    private void resetControls() {
        if (this.partialResultsTextView != null) {
            this.partialResultsTextView.setText((CharSequence)"");
        }
    }

    private void setAIButtonCallback(AIButton aiButton) {
        aiButton.setResultsListener(new AIButton.AIButtonListener(){

            @Override
            public void onResult(AIResponse result) {
                AIDialog.this.close();
                if (AIDialog.this.resultsListener != null) {
                    AIDialog.this.resultsListener.onResult(result);
                }
            }

            @Override
            public void onError(AIError error) {
                if (AIDialog.this.resultsListener != null) {
                    AIDialog.this.resultsListener.onError(error);
                }
            }

            @Override
            public void onCancelled() {
                AIDialog.this.close();
                if (AIDialog.this.resultsListener != null) {
                    AIDialog.this.resultsListener.onCancelled();
                }
            }
        });
        aiButton.setPartialResultsListener(new PartialResultsListener(){

            @Override
            public void onPartialResults(List<String> partialResults) {
                final String result = partialResults.get(0);
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    AIDialog.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (AIDialog.this.partialResultsTextView != null) {
                                AIDialog.this.partialResultsTextView.setText((CharSequence)result);
                            }
                        }
                    });
                }
            }
        });
    }

    private void startListening() {
        if (this.aiButton != null) {
            this.aiButton.startListening();
        }
    }

    public void close() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                AIDialog.this.dialog.dismiss();
            }
        });
    }

    public static interface AIDialogListener {
        public void onResult(AIResponse var1);

        public void onError(AIError var1);

        public void onCancelled();
    }
}

