/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import ai.api.AIConfiguration;
import ai.api.AIServiceException;
import ai.api.GsonFactory;
import ai.api.RequestExtras;
import ai.api.UserEntityWrapper;
import ai.api.http.HttpClient;
import ai.api.model.AIContext;
import ai.api.model.AIRequest;
import ai.api.model.AIResponse;
import ai.api.model.Entity;
import ai.api.model.Status;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class AIDataService {
    public static final String TAG = AIDataService.class.getName();
    @NonNull
    private final Context context;
    @NonNull
    private final AIConfiguration config;
    @NonNull
    private final String sessionId;
    @NonNull
    private final Gson gson = GsonFactory.getGson();

    public AIDataService(@NonNull Context context, @NonNull AIConfiguration config) {
        this.context = context;
        this.config = config;
        this.sessionId = UUID.randomUUID().toString();
    }

    @NonNull
    public AIResponse request(AIRequest request) throws AIServiceException {
        if (request == null) {
            throw new IllegalArgumentException("Request argument must not be null");
        }
        Log.d((String)TAG, (String)"Start request");
        try {
            request.setLanguage(this.config.getLanguage());
            request.setSessionId(this.sessionId);
            request.setTimezone(Calendar.getInstance().getTimeZone().getID());
            String queryData = this.gson.toJson((Object)request);
            Log.d((String)TAG, (String)("Request json: " + queryData));
            String response = this.doTextRequest(queryData);
            if (TextUtils.isEmpty((CharSequence)response)) {
                throw new AIServiceException("Empty response from ai service. Please check configuration and Internet connection.");
            }
            Log.d((String)TAG, (String)("Response json: " + response));
            AIResponse aiResponse = (AIResponse)this.gson.fromJson(response, AIResponse.class);
            if (aiResponse == null) {
                throw new AIServiceException("API.AI response parsed as null. Check debug log for details.");
            }
            if (aiResponse.isError()) {
                throw new AIServiceException(aiResponse);
            }
            aiResponse.cleanup();
            return aiResponse;
        }
        catch (MalformedURLException e) {
            Log.e((String)TAG, (String)"Malformed url should not be raised", (Throwable)e);
            throw new AIServiceException("Wrong configuration. Please, connect to API.AI Service support", e);
        }
        catch (JsonSyntaxException je) {
            throw new AIServiceException("Wrong service answer format. Please, connect to API.AI Service support", je);
        }
    }

    @NonNull
    public AIResponse voiceRequest(@NonNull InputStream voiceStream) throws AIServiceException {
        return this.voiceRequest(voiceStream, new RequestExtras());
    }

    @NonNull
    public AIResponse voiceRequest(@NonNull InputStream voiceStream, @Nullable List<AIContext> aiContexts) throws AIServiceException {
        return this.voiceRequest(voiceStream, new RequestExtras(aiContexts, null));
    }

    @NonNull
    public AIResponse voiceRequest(@NonNull InputStream voiceStream, @Nullable RequestExtras requestExtras) throws AIServiceException {
        Log.d((String)TAG, (String)"Start voice request");
        try {
            AIRequest request = new AIRequest();
            request.setLanguage(this.config.getLanguage());
            request.setSessionId(this.sessionId);
            request.setTimezone(Calendar.getInstance().getTimeZone().getID());
            if (requestExtras != null) {
                if (requestExtras.hasContexts()) {
                    request.setContexts(requestExtras.getContexts());
                }
                if (requestExtras.hasEntities()) {
                    request.setEntities(requestExtras.getEntities());
                }
            }
            String queryData = this.gson.toJson((Object)request);
            Log.d((String)TAG, (String)("Request json: " + queryData));
            String response = this.doSoundRequest(voiceStream, queryData);
            if (TextUtils.isEmpty((CharSequence)response)) {
                throw new AIServiceException("Empty response from ai service. Please check configuration.");
            }
            Log.d((String)TAG, (String)("Response json: " + response));
            AIResponse aiResponse = (AIResponse)this.gson.fromJson(response, AIResponse.class);
            if (aiResponse == null) {
                throw new AIServiceException("API.AI response parsed as null. Check debug log for details.");
            }
            if (aiResponse.isError()) {
                throw new AIServiceException(aiResponse);
            }
            aiResponse.cleanup();
            return aiResponse;
        }
        catch (MalformedURLException e) {
            Log.e((String)TAG, (String)"Malformed url should not be raised", (Throwable)e);
            throw new AIServiceException("Wrong configuration. Please, connect to AI Service support", e);
        }
        catch (JsonSyntaxException je) {
            throw new AIServiceException("Wrong service answer format. Please, connect to API.AI Service support", je);
        }
    }

    public boolean resetContexts() {
        AIRequest cleanRequest = new AIRequest();
        cleanRequest.setQuery("empty_query_for_resetting_contexts");
        cleanRequest.setResetContexts(true);
        try {
            AIResponse response = this.request(cleanRequest);
            return !response.isError();
        }
        catch (AIServiceException e) {
            Log.e((String)TAG, (String)"Exception while contexts clean.", (Throwable)e);
            return false;
        }
    }

    public AIResponse uploadUserEntity(Entity userEntity) throws AIServiceException {
        UserEntityWrapper wrapper = new UserEntityWrapper(userEntity, this.sessionId);
        String requestData = this.gson.toJson((Object)wrapper);
        try {
            String response = this.doTextRequest(this.config.getUserEntitiesEndpoint(), requestData);
            if (TextUtils.isEmpty((CharSequence)response)) {
                throw new AIServiceException("Empty response from ai service. Please check configuration and Internet connection.");
            }
            Log.d((String)TAG, (String)("Response json: " + response));
            AIResponse aiResponse = (AIResponse)this.gson.fromJson(response, AIResponse.class);
            if (aiResponse == null) {
                throw new AIServiceException("API.AI response parsed as null. Check debug log for details.");
            }
            if (aiResponse.isError()) {
                throw new AIServiceException(aiResponse);
            }
            aiResponse.cleanup();
            return aiResponse;
        }
        catch (MalformedURLException e) {
            Log.e((String)TAG, (String)"Malformed url should not be raised", (Throwable)e);
            throw new AIServiceException("Wrong configuration. Please, connect to AI Service support", e);
        }
        catch (JsonSyntaxException je) {
            throw new AIServiceException("Wrong service answer format. Please, connect to API.AI Service support", je);
        }
    }

    protected String doTextRequest(String requestJson) throws MalformedURLException, AIServiceException {
        return this.doTextRequest(this.config.getQuestionUrl(), requestJson);
    }

    /*
     * Unable to fully structure code
     */
    protected String doTextRequest(String endpoint, String requestJson) throws MalformedURLException, AIServiceException {
        connection = null;
        try {
            url = new URL(endpoint);
            queryData = requestJson;
            Log.d((String)AIDataService.TAG, (String)("Request json: " + queryData));
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.addRequestProperty("Authorization", "Bearer " + this.config.getApiKey());
            connection.addRequestProperty("ocp-apim-subscription-key", this.config.getSubscriptionKey());
            connection.addRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.addRequestProperty("Accept", "application/json");
            connection.connect();
            outputStream = new BufferedOutputStream(connection.getOutputStream());
            IOUtils.write((String)queryData, (OutputStream)outputStream, (Charset)Charsets.UTF_8);
            outputStream.close();
            inputStream = new BufferedInputStream(connection.getInputStream());
            response = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            inputStream.close();
            var9_13 = response;
            return var9_13;
        }
        catch (IOException e) {
            if (connection == null) ** GOTO lbl34
            try {
                errorString = IOUtils.toString((InputStream)connection.getErrorStream(), (Charset)Charsets.UTF_8);
                Log.d((String)AIDataService.TAG, (String)("" + errorString));
                var6_10 = errorString;
                return var6_10;
            }
            catch (IOException ex) {
                Log.w((String)AIDataService.TAG, (String)"Can't read error response", (Throwable)ex);
lbl34:
                // 2 sources

                Log.e((String)AIDataService.TAG, (String)"Can't make request to the API.AI service. Please, check connection settings and API access token.", (Throwable)e);
                throw new AIServiceException("Can't make request to the API.AI service. Please, check connection settings and API access token.", e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected String doSoundRequest(@NonNull InputStream voiceStream, @NonNull String queryData) throws MalformedURLException, AIServiceException {
        HttpURLConnection connection = null;
        HttpClient httpClient = null;
        try {
            String response;
            URL url = new URL(this.config.getQuestionUrl());
            connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("Authorization", "Bearer " + this.config.getApiKey());
            connection.addRequestProperty("ocp-apim-subscription-key", this.config.getSubscriptionKey());
            connection.addRequestProperty("Accept", "application/json");
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            httpClient = new HttpClient(connection);
            httpClient.setWriteSoundLog(this.config.isWriteSoundLog());
            httpClient.connectForMultipart();
            httpClient.addFormPart("request", queryData);
            httpClient.addFilePart("voiceData", "voice.wav", voiceStream);
            httpClient.finishMultipart();
            String string = response = httpClient.getResponse();
            return string;
        }
        catch (IOException e) {
            if (httpClient != null) {
                String errorString = httpClient.getErrorString();
                Log.d((String)TAG, (String)("" + errorString));
                if (!TextUtils.isEmpty((CharSequence)errorString)) {
                    String string = errorString;
                    return string;
                }
                if (e instanceof HttpRetryException) {
                    AIResponse response = new AIResponse();
                    int code = ((HttpRetryException)e).responseCode();
                    Status status = Status.fromResponseCode(code);
                    status.setErrorDetails(((HttpRetryException)e).getReason());
                    response.setStatus(status);
                    throw new AIServiceException(response);
                }
            }
            Log.e((String)TAG, (String)"Can't make request to the API.AI service. Please, check connection settings and API.AI keys.", (Throwable)e);
            throw new AIServiceException("Can't make request to the API.AI service. Please, check connection settings and API.AI keys.", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

