/*
 * Decompiled with CFR 0.152.
 */
package ai.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.util.UUID;

public abstract class SessionIdStorage {
    private static final String PREF_NAME = "APIAI_preferences";
    private static final String SESSION_ID = "sessionId";

    public static synchronized String getSessionId(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_NAME, 0);
        String sessionId = sharedPreferences.getString(SESSION_ID, "");
        if (!TextUtils.isEmpty((CharSequence)sessionId)) {
            return sessionId;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        String value = UUID.randomUUID().toString();
        editor.putString(SESSION_ID, value);
        editor.commit();
        return value;
    }

    public static synchronized void resetSessionId(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_NAME, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(SESSION_ID, "");
        editor.commit();
    }
}

