/*
 * Decompiled with CFR 0.152.
 */
package ai.api.util;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.CountDownTimer;
import android.util.Log;

public abstract class BluetoothController {
    private Context mContext;
    private BluetoothAdapter mBluetoothAdapter;
    private AudioManager mAudioManager;
    private boolean mIsCountDownOn;
    private boolean mIsStarting;
    private boolean mIsOnHeadsetSco;
    private boolean mIsStarted;
    private static final String TAG = "BluetoothController";
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.bluetooth.device.action.ACL_CONNECTED")) {
                int deviceClass;
                BluetoothDevice mConnectedHeadset = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                BluetoothClass bluetoothClass = mConnectedHeadset.getBluetoothClass();
                if (bluetoothClass != null && ((deviceClass = bluetoothClass.getDeviceClass()) == 1032 || deviceClass == 1028)) {
                    BluetoothController.this.mAudioManager.setMode(3);
                    BluetoothController.this.mIsCountDownOn = true;
                    BluetoothController.this.mCountDown.start();
                    BluetoothController.this.onHeadsetConnected();
                }
                Log.d((String)BluetoothController.TAG, (String)(mConnectedHeadset.getName() + " connected"));
            } else if (action.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                Log.d((String)BluetoothController.TAG, (String)"Headset disconnected");
                if (BluetoothController.this.mIsCountDownOn) {
                    BluetoothController.this.mIsCountDownOn = false;
                    BluetoothController.this.mCountDown.cancel();
                }
                BluetoothController.this.mAudioManager.setMode(0);
                BluetoothController.this.onHeadsetDisconnected();
            } else if (action.equals("android.media.SCO_AUDIO_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                if (state == 1) {
                    BluetoothController.this.mIsOnHeadsetSco = true;
                    if (BluetoothController.this.mIsStarting) {
                        BluetoothController.this.mIsStarting = false;
                        BluetoothController.this.onHeadsetConnected();
                    }
                    if (BluetoothController.this.mIsCountDownOn) {
                        BluetoothController.this.mIsCountDownOn = false;
                        BluetoothController.this.mCountDown.cancel();
                    }
                    BluetoothController.this.onScoAudioConnected();
                    Log.d((String)BluetoothController.TAG, (String)"Sco connected");
                } else if (state == 0) {
                    Log.d((String)BluetoothController.TAG, (String)"Sco disconnected");
                    if (!BluetoothController.this.mIsStarting) {
                        BluetoothController.this.mIsOnHeadsetSco = false;
                        BluetoothController.this.mAudioManager.stopBluetoothSco();
                        BluetoothController.this.onScoAudioDisconnected();
                    }
                }
            }
        }
    };
    private CountDownTimer mCountDown = new CountDownTimer(10000L, 1000L){

        public void onTick(long millisUntilFinished) {
            try {
                BluetoothController.this.mAudioManager.startBluetoothSco();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Log.d((String)BluetoothController.TAG, (String)"\nonTick start bluetooth Sco");
        }

        public void onFinish() {
            BluetoothController.this.mIsCountDownOn = false;
            BluetoothController.this.mAudioManager.setMode(0);
            Log.d((String)BluetoothController.TAG, (String)"\nonFinish fail to connect to headset audio");
        }
    };

    public BluetoothController(Context context) {
        this.mContext = context;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    public boolean start() {
        if (!this.mIsStarted) {
            this.mIsStarted = true;
            this.mIsStarted = this.startBluetooth();
        }
        return this.mIsStarted;
    }

    public void stop() {
        if (this.mIsStarted) {
            this.mIsStarted = false;
            this.stopBluetooth();
        }
    }

    public boolean isOnHeadsetSco() {
        return this.mIsOnHeadsetSco;
    }

    public abstract void onHeadsetDisconnected();

    public abstract void onHeadsetConnected();

    public abstract void onScoAudioDisconnected();

    public abstract void onScoAudioConnected();

    private boolean startBluetooth() {
        Log.d((String)TAG, (String)"startBluetooth");
        if (this.mBluetoothAdapter != null && this.mAudioManager.isBluetoothScoAvailableOffCall()) {
            this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED"));
            this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
            this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.media.SCO_AUDIO_STATE_CHANGED"));
            this.mAudioManager.setMode(3);
            this.mIsCountDownOn = true;
            this.mCountDown.start();
            this.mIsStarting = true;
            return true;
        }
        return false;
    }

    private void stopBluetooth() {
        Log.d((String)TAG, (String)"stopBluetooth");
        if (this.mIsCountDownOn) {
            this.mIsCountDownOn = false;
            this.mCountDown.cancel();
        }
        this.mContext.unregisterReceiver(this.mBroadcastReceiver);
        this.mAudioManager.stopBluetoothSco();
        this.mAudioManager.setMode(0);
    }
}

