/*
 * Decompiled with CFR 0.152.
 */
package ai.api.services;

import ai.api.AIServiceException;
import ai.api.RequestExtras;
import ai.api.android.AIConfiguration;
import ai.api.android.AIService;
import ai.api.model.AIContext;
import ai.api.model.AIError;
import ai.api.model.AIResponse;
import ai.api.util.VoiceActivityDetector;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioRecord;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Deprecated
public class SpeaktoitRecognitionServiceImpl
extends AIService
implements VoiceActivityDetector.SpeechEventsListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    public static final String TAG = SpeaktoitRecognitionServiceImpl.class.getName();
    private static final int SAMPLE_RATE_IN_HZ = 16000;
    private static final int CHANNEL_CONFIG = 16;
    private static final int AUDIO_FORMAT = 2;
    private final ExecutorService eventsExecutor = Executors.newSingleThreadExecutor();
    private final VoiceActivityDetector vad = new VoiceActivityDetector(16000);
    private AudioRecord audioRecord;
    private final Object recognizerLock = new Object();
    private volatile boolean isRecording = false;
    private MediaPlayer mediaPlayer;
    private RequestExtras extras;
    private RecognizeTask recognizeTask;

    public SpeaktoitRecognitionServiceImpl(Context context, AIConfiguration config) {
        super(config, context);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.recognizerLock;
        synchronized (object) {
            int bufferSize = AudioRecord.getMinBufferSize((int)16000, (int)16, (int)2);
            this.audioRecord = new AudioRecord(1, 16000, 16, 2, bufferSize);
            this.vad.setEnabled(this.config.isVoiceActivityDetectionEnabled());
            this.vad.setSpeechListener(this);
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        }
    }

    @Override
    public void startListening() {
        this.startListening(new RequestExtras());
    }

    @Override
    public void startListening(List<AIContext> contexts) {
        this.startListening(new RequestExtras(contexts, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startListening(RequestExtras requestExtras) {
        Object object = this.recognizerLock;
        synchronized (object) {
            if (!this.isRecording) {
                if (!this.checkPermissions()) {
                    AIError aiError = new AIError("RECORD_AUDIO permission is denied. Please request permission from user.");
                    this.onError(aiError);
                    return;
                }
                this.isRecording = true;
                this.extras = requestExtras;
                AssetFileDescriptor startSound = this.config.getRecognizerStartSound();
                if (startSound != null) {
                    boolean success = this.playSound(startSound);
                    if (!success) {
                        this.startRecording(this.extras);
                    }
                } else {
                    this.startRecording(this.extras);
                }
            } else {
                Log.w((String)TAG, (String)"Trying start listening when it already active");
            }
        }
    }

    private void startRecording(RequestExtras extras) {
        this.vad.reset();
        this.audioRecord.startRecording();
        this.onListeningStarted();
        this.recognizeTask = new RecognizeTask(new RecorderStream(this.audioRecord), extras);
        this.recognizeTask.execute(new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopListening() {
        Object object = this.recognizerLock;
        synchronized (object) {
            if (this.isRecording) {
                try {
                    this.audioRecord.stop();
                    this.isRecording = false;
                    AssetFileDescriptor stopSound = this.config.getRecognizerStopSound();
                    if (stopSound != null) {
                        this.playSound(stopSound);
                    }
                    this.onListeningFinished();
                }
                catch (IllegalStateException e) {
                    Log.w((String)TAG, (String)"Attempt to stop audioRecord when it is stopped");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.recognizerLock;
        synchronized (object) {
            if (this.isRecording) {
                this.audioRecord.stop();
                this.isRecording = false;
                AssetFileDescriptor cancelSound = this.config.getRecognizerCancelSound();
                if (cancelSound != null) {
                    this.playSound(cancelSound);
                }
            }
            if (this.recognizeTask != null) {
                this.recognizeTask.cancel(true);
            }
            this.onListeningCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.recognizerLock;
        synchronized (object) {
            if (this.isRecording) {
                this.audioRecord.stop();
                this.isRecording = false;
            }
            this.audioRecord.release();
            this.audioRecord = null;
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    @Override
    public void resume() {
        this.init();
    }

    private boolean playSound(AssetFileDescriptor afd) {
        boolean result = true;
        try {
            this.mediaPlayer.stop();
            this.mediaPlayer.reset();
            this.mediaPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            this.mediaPlayer.prepare();
            this.mediaPlayer.start();
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    @Override
    public void onSpeechBegin() {
    }

    @Override
    public void onSpeechEnd() {
        this.eventsExecutor.submit(new Runnable(){

            @Override
            public void run() {
                SpeaktoitRecognitionServiceImpl.this.stopListening();
            }
        });
    }

    @Override
    public void onSpeechCancel() {
        this.eventsExecutor.submit(new Runnable(){

            @Override
            public void run() {
                SpeaktoitRecognitionServiceImpl.this.cancel();
            }
        });
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.isRecording) {
            this.startRecording(this.extras);
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        if (this.isRecording) {
            this.startRecording(this.extras);
        }
        return false;
    }

    private class RecognizeTask
    extends AsyncTask<Void, Void, AIResponse> {
        private final RecorderStream recorderStream;
        private final RequestExtras requestExtras;
        private AIError aiError;

        private RecognizeTask(RecorderStream recorderStream, RequestExtras requestExtras) {
            this.recorderStream = recorderStream;
            this.requestExtras = requestExtras;
        }

        protected AIResponse doInBackground(Void ... params) {
            try {
                return SpeaktoitRecognitionServiceImpl.this.aiDataService.voiceRequest(this.recorderStream, this.requestExtras);
            }
            catch (AIServiceException e) {
                this.aiError = new AIError(e);
                return null;
            }
        }

        protected void onPostExecute(AIResponse aiResponse) {
            if (this.isCancelled()) {
                return;
            }
            if (aiResponse != null) {
                SpeaktoitRecognitionServiceImpl.this.onResult(aiResponse);
            } else {
                SpeaktoitRecognitionServiceImpl.this.cancel();
                SpeaktoitRecognitionServiceImpl.this.onError(this.aiError);
            }
        }
    }

    private class RecorderStream
    extends InputStream {
        private final float dbLevel = (float)Math.pow(10.0, -0.05);
        private final AudioRecord audioRecord;
        private byte[] bytes;
        private final Object bytesLock = new Object();
        int offset = 0;
        int max = 0;
        int min = 0;
        float alignment = 0.0f;
        float count = 1.0f;
        int extent;

        private RecorderStream(AudioRecord audioRecord) {
            this.audioRecord = audioRecord;
        }

        @Override
        public int read() throws IOException {
            byte[] buffer = new byte[1];
            this.audioRecord.read(buffer, 0, 1);
            return buffer[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(@NonNull byte[] buffer, int byteOffset, int byteCount) throws IOException {
            int bytesRead = this.audioRecord.read(buffer, byteOffset, byteCount);
            if (bytesRead > 0) {
                Object object = this.bytesLock;
                synchronized (object) {
                    byte[] temp;
                    if (SpeaktoitRecognitionServiceImpl.this.config.isNormalizeInputSound()) {
                        this.normalize(buffer, bytesRead);
                    }
                    int tempLength = (temp = this.bytes) != null ? temp.length : 0;
                    this.bytes = new byte[tempLength + bytesRead];
                    if (tempLength > 0) {
                        System.arraycopy(temp, 0, this.bytes, 0, tempLength);
                    }
                    System.arraycopy(buffer, 0, this.bytes, tempLength, bytesRead);
                    while (this.bytes.length >= 320) {
                        byte[] b = new byte[320];
                        System.arraycopy(this.bytes, 0, b, 0, 320);
                        SpeaktoitRecognitionServiceImpl.this.vad.processBuffer(b, 320);
                        temp = this.bytes;
                        int newLength = temp.length - 320;
                        this.bytes = new byte[newLength];
                        System.arraycopy(temp, 320, this.bytes, 0, newLength);
                    }
                    SpeaktoitRecognitionServiceImpl.this.onAudioLevelChanged((float)SpeaktoitRecognitionServiceImpl.this.vad.calculateRms());
                }
            }
            return bytesRead != 0 ? bytesRead : -3;
        }

        private void normalize(@NonNull byte[] buffer, int bytesRead) {
            int remainOffset = 4800 - this.offset;
            if (bytesRead >= remainOffset) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, remainOffset, bytesRead - remainOffset).order(ByteOrder.LITTLE_ENDIAN);
                ShortBuffer shorts = byteBuffer.asShortBuffer();
                for (int i = 0; i < shorts.limit(); ++i) {
                    short sample = shorts.get(i);
                    this.max = Math.max(this.max, sample);
                    this.min = Math.min(this.min, sample);
                    this.alignment = (this.count - 1.0f) / this.count * this.alignment + (float)sample / this.count;
                    this.count += 1.0f;
                }
                this.extent = Math.max(Math.abs(this.max), Math.abs(this.min));
                float factor = this.dbLevel * 32767.0f / (float)this.extent;
                for (int i = 0; i < shorts.limit(); ++i) {
                    byteBuffer.putShort((short)(((float)shorts.get(i) - this.alignment) * factor));
                }
            }
            this.offset += Math.min(bytesRead, remainOffset);
        }
    }
}

