/*
 * Decompiled with CFR 0.152.
 */
package ai.api.ui;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;

public class SoundLevelCircleDrawable
extends Drawable {
    public static final int HALO_COLOR_DEF = Color.argb((int)16, (int)0, (int)0, (int)0);
    public static final int CENTER_COLOR_DEF = -889815;
    private static final float MIN_VALUE = 0.5f;
    private static final float MAX_VALUE = 10.0f;
    private static final float INITIAL_VALUE = 2.5f;
    private final float maxRadius;
    private final float minRadius;
    private final float circleCenterX;
    private final float circleCenterY;
    private float minMicLevel = 0.5f;
    private float maxMicLevel = 10.0f;
    private boolean drawSoundLevel = false;
    private final Paint paintIndicatorHalo;
    private final Paint paintIndicatorCenter;
    private float smoothedLevel = 2.5f;
    private final Rect bounds = new Rect();
    private boolean drawCenter = false;

    private static Paint newColorPaint(int color2) {
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        paint.setColor(color2);
        return paint;
    }

    public SoundLevelCircleDrawable() {
        this(null);
    }

    public SoundLevelCircleDrawable(@Nullable Params params) {
        int haloColor;
        int centerColor;
        if (params != null) {
            this.maxRadius = params.maxRadius;
            this.minRadius = params.minRadius;
            this.circleCenterX = params.circleCenterX;
            this.circleCenterY = params.circleCenterY;
            centerColor = params.centerColor;
            haloColor = params.haloColor;
        } else {
            this.maxRadius = -1.0f;
            this.minRadius = -1.0f;
            this.circleCenterX = -1.0f;
            this.circleCenterY = -1.0f;
            centerColor = -889815;
            haloColor = HALO_COLOR_DEF;
        }
        this.paintIndicatorHalo = SoundLevelCircleDrawable.newColorPaint(haloColor);
        this.paintIndicatorCenter = SoundLevelCircleDrawable.newColorPaint(centerColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Canvas canvas) {
        if (this.drawSoundLevel || this.drawCenter) {
            canvas.save();
            try {
                float y;
                if (this.maxRadius < 0.0f || this.circleCenterX < 0.0f || this.circleCenterY < 0.0f) {
                    canvas.getClipBounds(this.bounds);
                }
                canvas.drawColor(0);
                float levelInFraction = (this.smoothedLevel - this.minMicLevel) / (this.maxMicLevel - this.minMicLevel);
                float maxRadius = this.maxRadius < 0.0f ? (float)this.bounds.width() / 2.0f : this.maxRadius;
                float minRadius = this.minRadius < 0.0f ? maxRadius * 0.5777778f : this.minRadius;
                float soundMinRadius = minRadius * 0.8f;
                float rangeRadius = maxRadius - soundMinRadius;
                float soundRadius = soundMinRadius + rangeRadius * levelInFraction;
                float x = this.circleCenterX < 0.0f ? (float)this.bounds.width() / 2.0f : this.circleCenterX;
                float f = y = this.circleCenterY < 0.0f ? (float)this.bounds.height() / 2.0f : this.circleCenterY;
                if (this.drawSoundLevel) {
                    canvas.drawCircle(x, y, soundRadius, this.paintIndicatorHalo);
                }
                if (this.drawCenter || this.drawSoundLevel) {
                    canvas.drawCircle(x, y, minRadius, this.paintIndicatorCenter);
                }
            }
            finally {
                canvas.restore();
            }
        }
    }

    public void setAlpha(int ignored) {
    }

    public void setColorFilter(ColorFilter ignored) {
    }

    public int getOpacity() {
        return -3;
    }

    public boolean setDrawSoundLevel(boolean drawSoundLevel) {
        if (this.drawSoundLevel != drawSoundLevel) {
            this.drawSoundLevel = drawSoundLevel;
            if (drawSoundLevel) {
                this.minMicLevel = 0.5f;
                this.maxMicLevel = 10.0f;
                this.smoothedLevel = 2.5f;
            }
            return true;
        }
        return false;
    }

    public void setDrawCenter(boolean drawCenter) {
        this.drawCenter = drawCenter;
    }

    public void setSoundLevel(float soundLevel) {
        float positiveSoundLevel = Math.abs(soundLevel);
        if (positiveSoundLevel < this.minMicLevel) {
            this.minMicLevel = (this.minMicLevel + positiveSoundLevel) / 2.0f;
        }
        if (positiveSoundLevel > this.maxMicLevel) {
            this.maxMicLevel = (this.maxMicLevel + positiveSoundLevel) / 2.0f;
        }
        float alpha = 0.2f;
        this.smoothedLevel = this.smoothedLevel * 0.8f + positiveSoundLevel * 0.2f;
        if (this.smoothedLevel > this.maxMicLevel) {
            this.smoothedLevel = this.maxMicLevel;
        } else if (this.smoothedLevel < this.minMicLevel) {
            this.smoothedLevel = this.minMicLevel;
        }
    }

    public float getMinRadius() {
        return this.minRadius;
    }

    public static class Params {
        public final float maxRadius;
        public final float minRadius;
        public final float circleCenterX;
        public final float circleCenterY;
        private final int centerColor;
        private final int haloColor;

        public Params(float maxRadius, float minRadius, float circleCenterX, float circleCenterY, int centerColor, int haloColor) {
            this.maxRadius = maxRadius;
            this.minRadius = minRadius;
            this.circleCenterX = circleCenterX;
            this.circleCenterY = circleCenterY;
            this.centerColor = centerColor;
            this.haloColor = haloColor;
        }
    }
}

