/*
 * Decompiled with CFR 0.152.
 */
package ai.api.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import java.util.LinkedList;
import java.util.List;

public class RecognizerChecker {
    public static final String GOOGLE_RECOGNIZER_PACKAGE_NAME = "com.google.android.googlequicksearchbox";
    public static final String GOOGLE_VOICE_SEARCH_PACKAGE_NAME = "com.google.android.voicesearch";

    public static ComponentName findGoogleRecognizer(Context context) {
        return RecognizerChecker.findRecognizerByPackage(context, RecognizerChecker.getPackageName());
    }

    private static ComponentName findRecognizerByPackage(Context context, String prefPackage) {
        PackageManager pm = context.getPackageManager();
        List available = pm != null ? pm.queryIntentServices(new Intent("android.speech.RecognitionService"), 0) : new LinkedList();
        int numAvailable = available.size();
        if (numAvailable == 0) {
            return null;
        }
        if (prefPackage != null) {
            for (ResolveInfo anAvailable : available) {
                ServiceInfo serviceInfo = anAvailable.serviceInfo;
                if (serviceInfo == null || !prefPackage.equals(serviceInfo.packageName)) continue;
                return new ComponentName(serviceInfo.packageName, serviceInfo.name);
            }
        }
        return null;
    }

    public static String getGoogleRecognizerVersion(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            ComponentName recognizerComponentName = RecognizerChecker.findGoogleRecognizer(context);
            if (recognizerComponentName != null) {
                PackageInfo packageInfo = pm.getPackageInfo(recognizerComponentName.getPackageName(), 0);
                String versionName = packageInfo.versionName;
                return versionName;
            }
            return "";
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return "";
        }
    }

    public static boolean isGoogleRecognizerAvailable(Context context) {
        return RecognizerChecker.findGoogleRecognizer(context) != null;
    }

    private static String getPackageName() {
        if (Build.VERSION.SDK_INT >= 16) {
            return GOOGLE_RECOGNIZER_PACKAGE_NAME;
        }
        return GOOGLE_VOICE_SEARCH_PACKAGE_NAME;
    }
}

