package ai.apiverse.apisuite.scanner;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class EndpointService {

    private final List<EndpointInfo> endpoints = new ArrayList<>();
    Map<Class<?>,List<EndpointInfo>> controllerVsApis = new HashMap<>();

    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    //@PostConstruct
    public void scanEndpoints() {
        controllerVsApis.clear();
        endpoints.clear();
        requestMappingHandlerMapping.getHandlerMethods().forEach((info, method) -> {
            EndpointInfo endpointInfo = new ApiScannerConfig().getMappingInfo(info, method);
            Class<?> controller = method.getBeanType();
            List<EndpointInfo> apilist = controllerVsApis.getOrDefault(controller, new ArrayList<>());
            apilist.add(endpointInfo);
            controllerVsApis.put(controller,apilist);
            endpoints.add(endpointInfo);
        });
    }

    public Map<Class<?>, List<EndpointInfo>> getEndpoints() {
        scanEndpoints();
        return controllerVsApis;
    }

    // Rest of the code related to getting the mapping info
}
