package ai.apiverse.apisuite.controller;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class DummyData {

    // Additional data types
    private BigDecimal bigDecimalField;
    private BigInteger bigIntegerField;
    private LocalDate localDateField;
    private LocalDateTime localDateTimeField;
    private UUID uuidField;
    private StringBuilder stringBuilderField;
    private StringBuffer stringBufferField;
    private Class<?> classField;
    private EnumSample enumField;
    private Queue<String> stringQueue;

    private byte byteField;
    private short shortField;
    private int intField;
    private long longField;
    private float floatField;
    private double doubleField;
    private char charField;
    private boolean booleanField;

    // Wrapper classes
    private Byte wrappedByteField;
    private Short wrappedShortField;
    private Integer wrappedIntField;
    private Long wrappedLongField;
    private Float wrappedFloatField;
    private Double wrappedDoubleField;
    private Character wrappedCharField;
    private Boolean wrappedBooleanField;

    // String type
    private String stringField;

    // Arrays
    private int[] intArray;
    private String[] stringArray;

    // Collections
    private List<String> stringList;
    private Set<Integer> intSet;
    private Map<String, Integer> stringIntMap;

    private NestedDummyData nestedDummyData;

    private EnumSample enumSample;

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    @ToString
    public static class NestedDummyData {
        private int nestedField;
        private DeeperNestedDummyData deeperNestedDummyData;
    }

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    @ToString
    public static class DeeperNestedDummyData {
        private String deeperNestedField;
        private List<Map<String, List<Integer>>> complexNestedField;
    }

    public enum EnumSample {
        VALUE1,
        VALUE2
    }
}
