package ai.apiverse.apisuite.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.ResponseEntity;

@RestController
@RequestMapping("/api/c1")
public class MyController {

    private static final Logger logger = LoggerFactory.getLogger(MyController.class);

    @GetMapping("/get/{stringPathParam}/{intPathParam}")
    public ResponseEntity<Boolean> getMethod(@PathVariable String stringPathParam,
                                             @PathVariable Integer intPathParam,
                                             @RequestParam(required = false) String queryStringParam,
                                             @RequestParam(required = false) Integer queryIntParam,
                                             @RequestHeader HttpHeaders headers) {
        logger.info("GET request received with stringPathParam: {}, intPathParam: {}, queryStringParam: {}, queryIntParam: {}, headers: {}",
                stringPathParam, intPathParam, queryStringParam, queryIntParam, headers);
        return ResponseEntity.ok(true);
    }
    @PostMapping("/post")
    public ResponseEntity<Boolean> postMethod(@RequestBody DummyData dummyData) {
        logger.info("POST request received {}",dummyData);
        return ResponseEntity.ok(true);
    }

    @PutMapping("/put")
    public ResponseEntity<Boolean> putMethod() {
        logger.info("PUT request received");
        return ResponseEntity.ok(true);
    }

    @PatchMapping("/patch")
    public ResponseEntity<Boolean> patchMethod() {
        logger.info("PATCH request received");
        return ResponseEntity.ok(true);
    }

    @DeleteMapping("/delete")
    public ResponseEntity<Boolean> deleteMethod() {
        logger.info("DELETE request received");
        return ResponseEntity.ok(true);
    }

    @RequestMapping(value = "/options", method = RequestMethod.OPTIONS)
    public ResponseEntity<Boolean> optionsMethod() {
        logger.info("OPTIONS request received");
        return ResponseEntity.ok(true);
    }

    @RequestMapping(value = "/trace", method = RequestMethod.TRACE)
    public ResponseEntity<Boolean> traceMethod() {
        logger.info("TRACE request received");
        return ResponseEntity.ok(true);
    }

    @ExceptionHandler(Exception.class)
    public ResponseEntity<String> handleException(Exception e) {
        logger.error("An error occurred: {}", e.getMessage(), e);
        return ResponseEntity.status(500).body("An error occurred");
    }
}
