package ai.apiverse.apisuite.mirror.agent.buffer;

import ai.apiverse.apisuite.mirror.agent.commons.ObservedApi;
import ai.apiverse.apisuite.mirror.models.constant.HttpRequestMethod;
import ai.apiverse.apisuite.mirror.models.data.AgentConfig;
import ai.apiverse.apisuite.mirror.models.data.URI;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.experimental.FieldDefaults;

@FieldDefaults(makeFinal = true, level = AccessLevel.PRIVATE)
@RequiredArgsConstructor
@Getter
@Setter
public class ApiBufferKey {
    URI uri;
    HttpRequestMethod method;

    public static ApiBufferKey getApiBufferKeyFrom(ObservedApi observedApi) {
        return new ApiBufferKey(observedApi.getUri(), observedApi.getMethod());
    }
    public static ApiBufferKey getApiBufferKeyFrom(AgentConfig.ApiConfig apiConfig) {
        return new ApiBufferKey(apiConfig.getUri(), apiConfig.getMethod());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        // type check and cast
        if (getClass() != object.getClass()) {
            return false;
        }
        ApiBufferKey other = (ApiBufferKey) object;
        return this.method.equals(other.getMethod()) && this.uri.equals(other.getUri());
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.uri.hashCode();
        result = result * PRIME + this.method.hashCode();
        return result;
    }
}
