package ai.apiverse.apisuite.mirror.models.data;

import ai.apiverse.apisuite.mirror.models.constant.HttpRequestMethod;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.*;
import lombok.experimental.FieldDefaults;

import java.util.*;

// This class is Immutable.
@Builder
@Getter
@Setter
@FieldDefaults(level = AccessLevel.PRIVATE)
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode
@ToString
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AgentConfig {

    Integer bufferSyncFreqInSec;
    Boolean captureApiSample;
    Integer configFetchFreqInSec;
    List<ApiConfig> registeredApiConfigs = new ArrayList<>();
    Date timestamp;
    Integer discoveryBufferSize;
    Integer discoveryBufferSizePerApi;
    List<BlackListRule> blackListRules = new ArrayList<>();
    Map<String, String> maskHeaders = new HashMap<>();

    @EqualsAndHashCode
    @Getter
    @Setter
    @FieldDefaults(level = AccessLevel.PRIVATE)
    @NoArgsConstructor
    @ToString
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ApiConfig {
        URI uri;
        HttpRequestMethod method;
        Integer bufferSize;
        Boolean captureSampleRequest;
        Boolean captureSampleResponse;

        public ApiConfig(URI uri, HttpRequestMethod method, int bufferSize, boolean captureSampleRequest, boolean captureSampleResponse) {
            this.uri = uri;
            this.method = method;
            this.bufferSize = bufferSize;
            this.captureSampleRequest = captureSampleRequest;
            this.captureSampleResponse = captureSampleResponse;
        }
    }

    public static final AgentConfig noOpAgentConfig;

    static {
        noOpAgentConfig = new AgentConfig();
        noOpAgentConfig.setBufferSyncFreqInSec(20);
        noOpAgentConfig.setCaptureApiSample(false);// changed to true for testing purpose
       // noOpAgentConfig.setCaptureApiSample(true);
        noOpAgentConfig.setConfigFetchFreqInSec(120);
        noOpAgentConfig.setDiscoveryBufferSize(0);
        noOpAgentConfig.setDiscoveryBufferSizePerApi(0);
        noOpAgentConfig.setRegisteredApiConfigs(new ArrayList<>());
        noOpAgentConfig.setTimestamp(new Date(0));
    }

}
