package ai.apiverse.apisuite.mirror.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldDefaults;

import java.util.Map;

@Getter
@Setter
@FieldDefaults(level = AccessLevel.PRIVATE)
@AllArgsConstructor
public class HttpRequest<IN, OUT> {
    String url;
    IN requestBody;
    Map<String, String> queryParams;
    Map<String, String> requestHeaders;
    TypeReference<OUT> responseType;
}
