package ai.apiverse.apisuite.mirror.agent.commons;


import ai.apiverse.apisuite.mirror.models.constant.HttpRequestMethod;
import ai.apiverse.apisuite.mirror.models.data.AgentConfig;
import ai.apiverse.apisuite.mirror.models.data.URI;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.experimental.FieldDefaults;

@FieldDefaults(makeFinal = true, level = AccessLevel.PRIVATE)
@RequiredArgsConstructor
@Getter
@Setter
public class ObservedApi {
    URI uri;
    HttpRequestMethod method;

    public ObservedApi(String uriPath, HttpRequestMethod method) {
        this.uri = URI.getNonTemplatedURI(uriPath);
        this.method = method;
    }

    public boolean matches(AgentConfig.ApiConfig apiConfig) {
        if (apiConfig == null) {
            return false;
        }

        if (this.method != apiConfig.getMethod()) {
            return false;
        }
        return this.uri.equals(apiConfig.getUri());
    }

}
