package ai.apiverse.apisuite.mirror.agent.config;


import ai.apiverse.apisuite.mirror.models.data.AgentConfig;
import ai.apiverse.apisuite.mirror.models.data.URI;

public class AgentConfigUtils {
    public static boolean isConfigValid(AgentConfig agentConfig) {
        if (null == agentConfig) {
            return false;
        }
        if (null == agentConfig.getBufferSyncFreqInSec()) {
            return false;
        }
        if (null == agentConfig.getConfigFetchFreqInSec()) {
            return false;
        }
        if (null == agentConfig.getCaptureApiSample()) {
            return false;
        }
        if (null == agentConfig.getDiscoveryBufferSize()) {
            return false;
        }
        if (null == agentConfig.getDiscoveryBufferSizePerApi()) {
            return false;
        }
        if (null != agentConfig.getRegisteredApiConfigs()) {
            for (AgentConfig.ApiConfig apiConfig : agentConfig.getRegisteredApiConfigs()) {
                if (!isApiConfigValid(apiConfig)) {
                    return false;
                }
            }
        }
        return true;
    }

    static boolean isApiConfigValid(AgentConfig.ApiConfig apiConfig) {
        if (null == apiConfig) {
            return false;
        }
        if (!isURIValid(apiConfig.getUri())) {
            return false;
        }
        if (null == apiConfig.getMethod()) {
            return false;
        }
        if (null == apiConfig.getBufferSize()) {
            return false;
        }
        if (null == apiConfig.getCaptureSampleRequest()) {
            return false;
        }
        if (null == apiConfig.getCaptureSampleResponse()) {
            return false;
        }
        return true;
    }

    static boolean isURIValid(URI uri) {
        if (null == uri) {
            return false;
        }
        if (null == uri.getUriPath() || uri.getUriPath().length() == 0) {
            return false;
        }
        return true;
    }
}

