package ai.apiverse.apisuite.mirror.models.constant;

import lombok.Getter;

public interface ApimonitorCommonConstant {
    String DATA_CATEGORY_MESSAGE_ATTRIBUTE_KEY = "DATA_CATEGORY";
    String CONTENT_TYPE_HEADER_LOWER_CASE = "content-type";
    String CONTENT_TYPE_HEADER_JSON_VALUE = "application/json";
    String MASKING_RULES_CONFIGURATION_NAME = "PIIMaskingRules";
    String DEFAULT_MASK_REPLACEMENT = "MASKED";

    String MASKED_VALUE_SUFFIX = "SL_MASK";


    enum DataSizeUnit {
        KB,
        MB,
        GB
    }

    enum DataCategory {
        SAMPLE_DATA
    }

    enum ContentType {
        JSON("application/json"),
        FORM_URLENCODED("application/x-www-form-urlencoded"),
        TEXT("text/plain"),
        MULTIPART_FORM_DATA("multipart/form-data"),
        UNKNOWN("unknown_header");
        @Getter
        String headerValue;

        ContentType(String headerValue) {
            this.headerValue = headerValue;
        }

        public static ContentType getContentTypeFrom(String headerValue) {
            if (null == headerValue) {
                return ContentType.UNKNOWN;
            }
            for (ContentType contentType : ContentType.values()) {
                if (headerValue.toLowerCase().contains(contentType.headerValue.toLowerCase())) {
                    return contentType;
                }
            }
            return ContentType.UNKNOWN;
        }
    }
}
