package ai.apiverse.apisuite.mirror.utils;

import java.util.ArrayList;
import java.util.List;

public class ApimonitorCommonUtils {
    public static boolean isBlank(CharSequence cs) {
        int strLen = length(cs);
        if (strLen == 0) {
            return true;
        } else {
            for (int i = 0; i < strLen; ++i) {
                if (!Character.isWhitespace(cs.charAt(i))) {
                    return false;
                }
            }

            return true;
        }
    }

    public static List<String> split(String str, String delimiter) {
        if (null == str || str.length() == 0) {
            return new ArrayList<>();
        }
        String[] splits = str.split(delimiter);
        List<String> stringList = new ArrayList<>();
        for (String split : splits) {
            if (null == split || split.length() == 0) {
                continue;
            }
            stringList.add(split);
        }
        return stringList;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isEmpty(CharSequence cs) {
        return length(cs) == 0;
    }

    public static boolean isParsableNumber(String str) {
        if (isEmpty(str)) {
            return false;
        } else if (str.charAt(str.length() - 1) == '.') {
            return false;
        } else if (str.charAt(0) == '-') {
            return str.length() == 1 ? false : withDecimalsParsing(str, 1);
        } else {
            return withDecimalsParsing(str, 0);
        }
    }

    private static boolean withDecimalsParsing(String str, int beginIdx) {
        int decimalPoints = 0;

        for (int i = beginIdx; i < str.length(); ++i) {
            boolean isDecimalPoint = str.charAt(i) == '.';
            if (isDecimalPoint) {
                ++decimalPoints;
            }

            if (decimalPoints > 1) {
                return false;
            }

            if (!isDecimalPoint && !Character.isDigit(str.charAt(i))) {
                return false;
            }
        }

        return true;
    }
}
