package ai.apiverse.apisuite.mirror.utils;

import ai.apiverse.apisuite.mirror.models.data.URI;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class URIUtils {

    public static Pattern alphaNumericPattern = Pattern.compile("^[a-zA-Z0-9]*$");

     /*public static boolean compare(RegisteredApi templatedUri1, RegisteredApi templatedUri2) {
        List<String> templatedPathSegments1 = getPathSegments(templatedUri1.getTemplatedUri());
        List<String> templatedPathSegments2 = getPathSegments(templatedUri2.getTemplatedUri());

        if (templatedPathSegments1.size() == templatedPathSegments2.size()) {
            for (int i = 0; i < templatedPathSegments1.size(); i++) {
                if (isPathSegmentTemplate(templatedPathSegments1.get(i)) || isPathSegmentTemplate(templatedPathSegments2.get(i))) {
                    continue;  // If the segment is templated, we skip it's comparison.
                } else {
                    if (!templatedPathSegments1.get(i).equals(templatedPathSegments2.get(i))) {
                        return false;  // If one of the segment doesn't matches, we return false.
                    }
                }
            }
            // If after the loop, we still haven't returned, it means all the segments had a match.
            return true;
        } else {
            return false;
        }
    }*/


    public static boolean arePathSegmentMatching(String pathVariableA, String pathVariableB) {
        if (null == pathVariableA && null == pathVariableB) {
            return true;
        }
        if (null == pathVariableA || null == pathVariableB) {
            return false;
        }

        if (ApimonitorCommonUtils.isBlank(pathVariableA) && ApimonitorCommonUtils.isBlank(pathVariableB)) {
            return true;
        }

        if (ApimonitorCommonUtils.isBlank(pathVariableA) || ApimonitorCommonUtils.isBlank(pathVariableB)) {
            return false;
        }
        if (pathVariableA.equals(pathVariableB)) {
            return true;
        }
        boolean isPathVariableATemplate = isPathSegmentTemplate(pathVariableA);
        boolean isPathVariableBTemplate = isPathSegmentTemplate(pathVariableB);
        if (isPathVariableATemplate && isPathVariableBTemplate) {
            return false;
        }
        if (!isPathVariableATemplate && !isPathVariableBTemplate) {
            return false;
        }
        if (isPathVariableATemplate) {
            return pathSegmentBelongsTo(pathVariableB, pathVariableA);
        } else {
            return pathSegmentBelongsTo(pathVariableA, pathVariableB);
        }
    }

    private static boolean pathSegmentBelongsTo(String pathSegment, String pathVariable) {
        URI.PathSegment templatePathSegment = getPathSegment(pathVariable);
        if (isNumericSegment(templatePathSegment)) {
            return isNumeric(pathSegment);
        }
        if (isUUIDSegment(templatePathSegment)) {
            return isUUID(pathSegment) || isIdType(pathSegment);
        }
        if (templatePathSegment.getSegmentTemplateDataType() == URI.SegmentTemplateDataType.STRING) {
            if (isNumeric(pathSegment) || isUUID(pathSegment) || isIdType(pathSegment)) {
                return false;
            }
        }
        return true;
    }

    // Utility functions.
    public static boolean isPathSegmentTemplate(String pathSegment) {
        if (ApimonitorCommonUtils.isBlank(pathSegment)) {
            return false;
        }
        String trimmedPathSegment = pathSegment.trim();
        return trimmedPathSegment.startsWith("{") && trimmedPathSegment.endsWith("}");
    }

    public static String getVariableId(String pathSegment) {
        String trimmedPathSegment = pathSegment.trim();
        return trimmedPathSegment.substring(1, trimmedPathSegment.length() - 1);
    }

    public static List<String> getPathSegments(String uri) {
        if (ApimonitorCommonUtils.isBlank(uri)) {
            return new ArrayList<>();
        }
        return ApimonitorCommonUtils.split(uri, "/");
    }

    public static URI.PathSegment getClosedMatchingPathSegment(URI.PathSegment pathSegment, List<URI.PathSegment> candidates) {
        if (null == pathSegment || null == candidates || candidates.size() == 0) {
            return null;
        }
        if (pathSegment.isTemplatedSegment()) {
            return candidates.
                    stream().
                    filter(URI.PathSegment::isTemplatedSegment).
                    filter(candidate -> pathSegment.getSegmentTemplateDataType() == candidate.getSegmentTemplateDataType()).
                    findFirst().orElse(null);
        } else {
            URI.PathSegment exactMatch = candidates.
                    stream().
                    filter(candidate -> !candidate.isTemplatedSegment()).
                    filter(candidate -> candidate.getSegmentName().equals(pathSegment.getSegmentName())).
                    findFirst().orElse(null);
            if (null != exactMatch) {
                return exactMatch;
            }
            if (isNumericSegment(pathSegment)) {
                return closedMatchingTemplate(candidates, URI.SegmentTemplateDataType.NUMBER).orElse(null);
            }
            if (isUUIDSegment(pathSegment)) {
                return closedMatchingTemplate(candidates, URI.SegmentTemplateDataType.UUID).orElse(null);
            }
            return closedMatchingTemplate(candidates, URI.SegmentTemplateDataType.STRING).orElse(null);
        }
    }

    public static Optional<URI.PathSegment> closedMatchingTemplate(List<URI.PathSegment> candidates, URI.SegmentTemplateDataType type) {
        return candidates.
                stream().
                filter(URI.PathSegment::isTemplatedSegment).
                filter(candidate -> candidate.getSegmentTemplateDataType() == type).
                findFirst();
    }


    public static boolean isNumericSegment(URI.PathSegment pathSegment) {
        if (pathSegment.isTemplatedSegment()) {
            return pathSegment.getSegmentTemplateDataType() == URI.SegmentTemplateDataType.NUMBER;
        } else {
            return ApimonitorCommonUtils.isParsableNumber(pathSegment.getSegmentName());
        }
    }

    public static boolean isUUIDSegment(URI.PathSegment pathSegment) {
        if (pathSegment.isTemplatedSegment()) {
            return pathSegment.getSegmentTemplateDataType() == URI.SegmentTemplateDataType.UUID;
        } else {
            return isUUID(pathSegment.getSegmentName()) || isIdType(pathSegment.getSegmentName());
        }
    }

    public static boolean isIdType(String pathString) {
        if (null == pathString || pathString.length() < 10) {
            return false;
        }
        int intCount = 0;
        int charCount = 0;
        for (int i = 0; i < pathString.length(); i++) {
            if (Character.isDigit(pathString.charAt(i))) {
                intCount += 1;
            } else if (Character.isLetter(pathString.charAt(i))) {
                charCount += 1;
            }
        }
        if (charCount > 1 && intCount > 4) {
            return true;
        }
        return false;
    }

    public static boolean isUUID(String string) {
        List<String> splits = ApimonitorCommonUtils.split(string, "-");
        if (splits.size() != 5) {
            return false;
        }
        for (String split : splits) {
            Matcher matcher = alphaNumericPattern.matcher(split);
            if (!matcher.matches()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        return ApimonitorCommonUtils.isParsableNumber(string);
    }

    public static List<URI.PathSegment> filterNumericNonTemplateSegments(List<URI.PathSegment> segments) {
        if (null == segments) {
            return null;
        }
        return segments.
                stream().
                filter(URIUtils::isNumericNonTemplateSegment).
                collect(Collectors.toList());

    }

    public static boolean isNumericNonTemplateSegment(URI.PathSegment pathSegment) {
        if (null == pathSegment) {
            return false;
        }
        if (pathSegment.isTemplatedSegment()) {
            return false;
        }
        return isNumeric(pathSegment.getSegmentName());
    }

    public static List<URI.PathSegment> filterUUIDNonTemplateSegments(List<URI.PathSegment> segments) {
        if (null == segments) {
            return null;
        }
        return segments.
                stream().
                filter(URIUtils::isUUIDNonTemplateSegment).
                collect(Collectors.toList());
    }

    public static boolean isUUIDNonTemplateSegment(URI.PathSegment pathSegment) {
        if (null == pathSegment) {
            return false;
        }
        if (pathSegment.isTemplatedSegment()) {
            return false;
        }
        return isUUID(pathSegment.getSegmentName());
    }

    public static boolean isTemplateSegment(URI.PathSegment pathSegment) {
        if (null == pathSegment) {
            return false;
        }
        return pathSegment.isTemplatedSegment();
    }

    public static URI.PathSegment getDeepClone(URI.PathSegment pathSegment) {
        URI.PathSegment cloneSegment = new URI.PathSegment();
        cloneSegment.setSegmentTemplateDataType(pathSegment.getSegmentTemplateDataType());
        cloneSegment.setTemplatedSegment(pathSegment.isTemplatedSegment());
        cloneSegment.setSegmentName(pathSegment.getSegmentName());
        return cloneSegment;
    }

    public static URI.PathSegment getPathSegment(String segmentName) {
        if (URIUtils.isPathSegmentTemplate(segmentName)) {
            return getTemplateSegment(URI.SegmentTemplateDataType.getTemplateDataTypeByDisplayName(segmentName));
        } else {
            return getNonTemplateSegment(segmentName);
        }
    }

    public static URI.PathSegment getNonTemplateSegment(String segmentName) {
        URI.PathSegment pathSegment = new URI.PathSegment();
        pathSegment.setSegmentName(segmentName);
        pathSegment.setTemplatedSegment(false);
        return pathSegment;
    }

    public static URI.PathSegment getTemplateSegment(URI.SegmentTemplateDataType segmentTemplateDataType) {
        URI.PathSegment pathSegment = new URI.PathSegment();
        pathSegment.setTemplatedSegment(true);
        pathSegment.setSegmentTemplateDataType(segmentTemplateDataType);
        pathSegment.setSegmentName(segmentTemplateDataType.getPathDisplayName());
        return pathSegment;
    }

    public static URI getURIFrom(List<URI.PathSegment> pathSegments) {
        if (null == pathSegments || pathSegments.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean hasPathVariable = false;
        for (URI.PathSegment pathSegment : pathSegments) {
            stringBuffer.append("/");
            hasPathVariable = hasPathVariable || pathSegment.isTemplatedSegment();
            stringBuffer.append(pathSegment.getSegmentName());
        }
        return new URI(stringBuffer.toString(), hasPathVariable);
    }

}