package ai.apiverse.apisuite.mirror.agent;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MaskingUtils {
    public static Map<String, String> getReplacedHeaders(Map<String, String> headerMap, List<String> maskHeaders) {
        if (headerMap == null || maskHeaders == null || maskHeaders.size() == 0) return headerMap;

        Set<String> headerNames = headerMap.keySet();

        headerNames.forEach(headerName -> {
            Optional<String> foundHeader = maskHeaders.stream()
                    .filter(hn -> hn.equalsIgnoreCase(headerName))
                    .findAny();

            if (foundHeader.isPresent()) {
                headerMap.put(headerName, "\uD83D\uDD12MASKED\uD83D\uDD12");
            }
        });


        return headerMap;
    }
}
