package ai.apiverse.apisuite.mirror.agent;

import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Getter
@Setter
@Configuration
public class ApimonitorHttpConnectionConfig {
    @Value("#{new Integer('${apimonitor.http.maxTotalConnections:3}')}")
    private Integer maxConnTotal;

    @Value("#{new Integer('${apimonitor.http.socketTimeoutMs:6000}')}")
    private Integer socketTimeout;

    @Value("#{new Integer('${apimonitor.http.connectTimeoutMs:6000}')}")
    private Integer connectTimeout;

    @Value("#{new Integer('${apimonitor.http.readTimeout:6000}')}")
    private Integer readTimeout;

    @Value("#{new Integer('${apimonitor.http.connectionRequestTimeoutMs:6000}')}")
    private Integer connectionRequestTimeout;

    @Value("#{new Integer('${apimonitor.http.maxSingleRouteConnections:3}')}")
    private Integer maxConnPerRoute;

    @Value("#{new Integer('${apimonitor.http.idleConnectionWaitTimeMs:30000}')}")
    private Integer idleConnectionWaitTime;

    @Value("#{new Integer('${apimonitor.http.defaultKeepAliveTimeMs:30000}')}")
    private Integer defaultKeepAliveTime;

    @Value("#{new Integer('${apimonitor.http.maxRetries:3}')}")
    private int retryCount;
}
