package ai.apiverse.apisuite.mirror.agent.buffer;

import ai.apiverse.apisuite.mirror.models.data.APISample;

import java.util.concurrent.ArrayBlockingQueue;

// Thread-safe
public class SimpleBuffer implements Buffer {
    private final ArrayBlockingQueue<APISample> arrayBlockingQueue;
    int size;

    public SimpleBuffer(int size) {
        this.size = size;
        this.arrayBlockingQueue = new ArrayBlockingQueue<APISample>(size);
    }

    @Override
    public boolean offer(APISample apiSample) {
        return this.arrayBlockingQueue.offer(apiSample);
    }

    @Override
    public boolean canOffer() {
        return this.size > 0 && this.arrayBlockingQueue.remainingCapacity() > 0;
    }

    @Override
    public APISample poll() {
        return this.arrayBlockingQueue.poll();
    }

    @Override
    public boolean clear() {
        this.arrayBlockingQueue.clear();
        return true;
    }

    public int getContentCount() {
        return arrayBlockingQueue.size();
    }

}
