package ai.apiverse.apisuite.mirror.agent.buffer;

import ai.apiverse.apisuite.mirror.agent.config.ConfigUpdateListener;
import ai.apiverse.apisuite.mirror.agent.SDKLogger;
import ai.apiverse.apisuite.mirror.agent.config.ConfigManager;
import ai.apiverse.apisuite.mirror.models.data.AgentConfig;


public abstract class AbstractBufferManager implements ConfigUpdateListener {
    private final ConfigManager configManager;
    private BufferManagerWorker<ApiBufferKey> dummyWorker;

    public AbstractBufferManager(ConfigManager configManager, SDKLogger logger) {
        this.configManager = configManager;
        dummyWorker = new NoOpBufferManagerWorker<ApiBufferKey>(logger);
        this.worker = dummyWorker;
    }

    public BufferManagerWorker<ApiBufferKey> getWorker() {
        return this.worker;
    }

    // SimpleBufferManagerWorker is an immutable object. So we are not using any synchronization to publish.
    private BufferManagerWorker<ApiBufferKey> worker;

    abstract BufferManagerWorker<ApiBufferKey> createWorker(AgentConfig newConfig);

    public synchronized void onSuccessfulConfigUpdate(AgentConfig newAgentConfig) {
        if (isRefreshNeeded(worker.getOperatingConfig(), newAgentConfig)) {
            BufferManagerWorker<ApiBufferKey> oldBufferManagerWorker = worker;
            worker = createWorker(newAgentConfig);
            oldBufferManagerWorker.shutdown();
        }
    }
    public synchronized void onErroneousConfigUpdate() {
        BufferManagerWorker<ApiBufferKey> oldBuffer = worker;
        worker = dummyWorker;
        oldBuffer.shutdown();

    }

    public boolean init() {
        return configManager.subscribeToUpdates(this);
    }

    public boolean shutdown() {
        if (worker != null) {
            worker.shutdown();
            worker = null;
        }
        return true;
    }

    private boolean isRefreshNeeded(AgentConfig olderConfig, AgentConfig newConfig) {
        if (newConfig.getTimestamp().getTime() == 0 && olderConfig.getTimestamp().getTime() == 0) {
            return false;
        }
        return newConfig.getTimestamp().getTime() > olderConfig.getTimestamp().getTime();

    }
}
