package ai.apiverse.apisuite.mirror.agent.buffer;

import ai.apiverse.apisuite.mirror.agent.SDKLogger;
import ai.apiverse.apisuite.mirror.models.data.APISample;
import ai.apiverse.apisuite.mirror.models.data.AgentConfig;


public class NoOpBufferManagerWorker<K> extends BufferManagerWorker<K> {

    AgentConfig config;
    public NoOpBufferManagerWorker(SDKLogger logger) {
        super(logger);
        config = AgentConfig.noOpAgentConfig;
    }
    @Override
    public boolean init() {
        return true;
    }

    @Override
    public AgentConfig getOperatingConfig() {
        return config;
    }

    @Override
    public boolean offer(ApiBufferKey apiBufferKey, APISample apiSample) {
        return false;
    }

    @Override
    public boolean canOffer(ApiBufferKey apiBufferKey) {
        return false;
    }

    @Override
    public boolean offer(K k, APISample apiSample) {
        return false;
    }

    public boolean canOffer(K k) {
        return false;
    }

    @Override
    public boolean shutdown() {
        return true;
    }

    @Override
    void syncForKey(ApiBufferKey key) {
        return;
    }
}
