package ai.apiverse.apisuite.mirror.models.data;

import ai.apiverse.apisuite.mirror.models.constant.HttpRequestMethod;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.*;
import lombok.experimental.FieldDefaults;

import java.util.Map;

@Getter
@Setter
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class APISample {
    String rawUri;
    String applicationName;
    String hostName;
    int port;
    String scheme;
    HttpRequestMethod method;
    Map<String, String[]> parameters;
    Map<String, String> requestHeaders;
    Map<String, String> responseHeaders;
    int statusCode;
    String requestPayload;
    String responsePayload;
    String uncaughtExceptionMessage;
    Boolean payloadCaptureAttempted;
    Boolean requestPayloadCaptureAttempted;
    Boolean responsePayloadCaptureAttempted;
    Long latency;

    URI uri;

}

