package ai.apiverse.apisuite.mirror.models.data;

import ai.apiverse.apisuite.mirror.models.constant.HttpRequestMethod;

import ai.apiverse.apisuite.mirror.utils.ApimonitorCommonUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class BlackListRule {
    // blackListType: endsWith or absolute. the reason it is not a enum is so that
    // sdk does not break in case there is a version mismatch between sdk and
    // commons
    String blackListType;
    List<String> matchValues;
    HttpRequestMethod method;

    public boolean isValid() {
        if (ApimonitorCommonUtils.isBlank(blackListType)) {
            return false;
        }
        if (matchValues == null) {
            return false;
        }
        return true;
    }

    public boolean matchesUri(URI uri, HttpRequestMethod httpMethod) {
        if (!isValid()) {
            return false;
        }
        if (null == httpMethod || null == uri) {
            return false;
        }
        if (null != this.method && !this.method.equals(httpMethod)) {
            return false;
        }
        if (this.blackListType.equalsIgnoreCase("endsWith")) {
            for (String matchValue : this.matchValues) {
                if (uri.getUriPath().toLowerCase().endsWith(matchValue.toLowerCase())) {
                    return true;
                }
            }
        } else if (blackListType.equalsIgnoreCase("absolute")) {
            for (String matchValue : matchValues) {
                if (uri.equals(URI.getURI(matchValue))) {
                    return true;
                }
            }
        }
        return false;
    }
}
