package ai.apiverse.apisuite.scanner;

import lombok.Data;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class EndpointService  {

    private final List<EndpointInfo> endpoints = new ArrayList<>();
    Map<Class<?>,List<EndpointInfo>> controllerVsApis = new HashMap<>();

    private ApplicationContext applicationContext;

    //@PostConstruct
    public void scanEndpoints() {
        controllerVsApis.clear();
        endpoints.clear();
        RequestMappingHandlerMapping requestMappingHandlerMapping =
                applicationContext.getBean(RequestMappingHandlerMapping.class);
        requestMappingHandlerMapping.getHandlerMethods().forEach((info, method) -> {
            EndpointInfo endpointInfo = ApiScannerConfig.getInstance().getMappingInfo(info, method);
            Class<?> controller = method.getBeanType();
            List<EndpointInfo> apilist = controllerVsApis.getOrDefault(controller, new ArrayList<>());
            apilist.add(endpointInfo);
            controllerVsApis.put(controller,apilist);
            endpoints.add(endpointInfo);
        });
    }

    public Map<Class<?>, List<EndpointInfo>> getEndpoints() {
        scanEndpoints();
        return controllerVsApis;
    }
}
