package ai.benshi.android.sdk.e_commerce.currency_exchange

import ai.benshi.android.sdk.core.BenshiLog
import ai.benshi.android.sdk.core.retrofit.CurrencyMainObject
import ai.benshi.android.sdk.core.retrofit.CurrencyObject
import ai.benshi.android.sdk.core.utils.CoreConstants
import ai.benshi.android.sdk.e_commerce.event_models.CartObject
import ai.benshi.android.sdk.e_commerce.event_models.CheckoutObject
import ai.benshi.android.sdk.e_commerce.event_models.ViewItemObject
import ai.benshi.android.sdk.e_commerce.event_types.EComEventType
import ai.benshi.android.sdk.e_commerce.utils.ECommerceConstants
import android.content.Context
import android.util.Log
import io.paperdb.Paper
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.text.SimpleDateFormat
import java.util.*


/**
 * Created by Moiz Hassan on 17, March,2021
 */


internal class CurrencyAPIHandler : EcomLogInterface {

    fun initInterface(){
        EComLog.ecomLogInterface = this
    }
    override fun getPrice(
        context: Context?,
        fromCurrency: String,
        eventType: String,
        itemObject: Any?,
        updateImmediately: Boolean
    ) {

        val currencyObject : CurrencyMainObject? = Paper.book(CoreConstants.PaperDbSdkKey)
            .read(CoreConstants.usdRateObjectKey)

        if(currencyObject != null){
            val sdf = SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH)
            if(currencyObject.fromCurrency == fromCurrency &&
                (currencyObject.toCurrencyObject?.date == sdf.format(Calendar.getInstance().time)
                        || CoreConstants.isAgainRate)){
                checkAndAddUserValues(context, currencyObject,
                    eventType, itemObject, updateImmediately)
            }else{
                callCurrencyApi(context, fromCurrency,
                    eventType, itemObject, updateImmediately)
            }
        }else{
            callCurrencyApi(context, fromCurrency,
            eventType, itemObject, updateImmediately)
        }
        CoreConstants.isAgainRate = true

    }

    private fun checkAndAddUserValues(
        context: Context?,
        currencyObject : CurrencyMainObject,
        eventType: String,
        itemObject: Any?,
        updateImmediately: Boolean
    ) {

        when(eventType){
            EComEventType.item.name -> {
                val iObject = itemObject as ViewItemObject
                iObject.usd_rate = currencyObject.toCurrencyObject?.usd

                BenshiLog.track(
                    context!!, ECommerceConstants.contentBlockName, eventType,
                    iObject, updateImmediately
                )
            }
            EComEventType.cart.name -> {
                val iObject = itemObject as CartObject
                iObject.usd_rate = currencyObject.toCurrencyObject?.usd

                BenshiLog.track(
                    context!!, ECommerceConstants.contentBlockName, eventType,
                    iObject, updateImmediately
                )
            }
            EComEventType.checkout.name -> {
                val iObject = itemObject as CheckoutObject
                iObject.usd_rate = currencyObject.toCurrencyObject?.usd

                BenshiLog.track(
                    context!!, ECommerceConstants.contentBlockName, eventType,
                    iObject, updateImmediately
                )
            }
        }
    }

    private fun callCurrencyApi(context: Context?, fromCurrency: String,
                                eventType: String,
                                itemObject: Any?,
                                updateImmediately: Boolean){
        val apiInterface: CurrencyAPIInterface = CurrencyAPIClient.getClient()
            .create(CurrencyAPIInterface::class.java)

        val sdkToken  : String? = Paper.book(CoreConstants.PaperDbSdkKey).read(CoreConstants.apiTokenKey)

        val call: Call<CurrencyObject> = apiInterface.getUsdRate(sdkToken!!, fromCurrency)
        call.enqueue(object : Callback<CurrencyObject> {
            override fun onResponse(
                call: Call<CurrencyObject>,
                response: Response<CurrencyObject>
            ) {
                if (response.isSuccessful) {
                    Log.d(CoreConstants.SDKLogTag, response.message())
                    val currencyObject = CurrencyMainObject(fromCurrency, response.body())
                    checkAndAddUserValues(context, currencyObject,
                        eventType, itemObject, updateImmediately)

                    Paper.book(CoreConstants.PaperDbSdkKey)
                        .write(CoreConstants.usdRateObjectKey, currencyObject)

                }else{
                    BenshiLog.track(
                        context!!, ECommerceConstants.contentBlockName, eventType,
                        itemObject, updateImmediately
                    )
                }
            }

            override fun onFailure(call: Call<CurrencyObject>, throwable: Throwable) {
                call.cancel()
                Log.d(CoreConstants.SDKLogTag, throwable.message.toString())
                BenshiLog.track(
                    context!!, ECommerceConstants.contentBlockName, eventType,
                    itemObject, updateImmediately
                )
            }
        })

    }


}