package ai.benshi.android.sdk.e_commerce.utils.impression_listener.sdk

import ai.benshi.android.sdk.e_commerce.event_models.ItemModel
import ai.benshi.android.sdk.e_commerce.utils.impression_listener.trackers.TrackCollectionsUseCase
import ai.benshi.android.sdk.e_commerce.utils.impression_listener.trackers.TrackRecyclerViewUseCase
import ai.benshi.android.sdk.e_commerce.utils.impression_listener.ui.ImpressionThreshold
import android.app.Activity
import android.content.Context
import androidx.recyclerview.widget.RecyclerView

/**
 * Default implementation of the [BshRecyclerInterface] interface, which delegates each call to its
 * appropriate underlying use case. Calls to [shutdown] are delegated directly to the [logger].
 */
@Suppress("TooManyFunctions", "LongParameterList")
internal class DefaultSdk(
    private val trackCollectionsUseCase: TrackCollectionsUseCase,
    private val trackRecyclerViewUseCase: TrackRecyclerViewUseCase,
) : BshRecyclerInterface {


    override fun onCollectionVisible(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId : String,
        model: List<ItemModel>,
    ) = trackCollectionsUseCase.onCollectionVisible(sourceActivity, collectionViewKey, searchId, model)

    override fun onCollectionUpdated(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId : String,
        model: List<ItemModel>,
    ) = trackCollectionsUseCase.onCollectionUpdated(sourceActivity, collectionViewKey, searchId, model)

    override fun onCollectionHidden(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId : String
    ) =
        trackCollectionsUseCase.onCollectionHidden(sourceActivity, collectionViewKey, searchId)

    override fun trackRecyclerView(
        recyclerView: RecyclerView,
        currentDataProvider: () -> List<ItemModel>,
        searchId : String,
        impressionThresholdBlock: (ImpressionThreshold.Builder.() -> Unit)?
    ) = trackRecyclerViewUseCase.trackRecyclerView(
        recyclerView, currentDataProvider, searchId, impressionThresholdBlock
    )

    override fun trackRecyclerView(
        recyclerView: RecyclerView,
        currentDataProvider: () -> List<ItemModel>,
        searchId : String,
        impressionThreshold: ImpressionThreshold
    ) = trackRecyclerViewUseCase.trackRecyclerView(
        recyclerView, currentDataProvider, searchId, impressionThreshold
    )

    override fun shutdown(){}
}
