package ai.benshi.android.sdk.e_commerce.impression_listener

import ai.benshi.android.sdk.e_commerce.event_models.RecyclerItemModel
import ai.benshi.android.sdk.e_commerce.impression_listener.sdk.BshRecyclerInterface
import ai.benshi.android.sdk.e_commerce.impression_listener.sdk.SdkManager
import ai.benshi.android.sdk.e_commerce.impression_listener.ui.ImpressionThreshold
import android.annotation.SuppressLint
import android.app.Activity
import android.app.Application
import androidx.recyclerview.widget.RecyclerView

/**
 * Single entry-point for the Promoted.Ai SDK. All SDK operations can be safely executed through
 * here without worrying about underlying dependencies / classes / object management.
 */
object BshEComScroll {
    @SuppressLint("StaticFieldLeak")
    private val manager = SdkManager()
    private val sdk get() = manager.sdkInstance

    /**
     * @see [SdkManager.initialize]
     */
    @JvmStatic
    fun initialize(application: Application, block: ClientConfig.Builder.() -> Unit) =
        manager.initialize(application, block)

    /**
     * @see [SdkManager.initialize]
     */
    @JvmStatic
    fun initialize(application: Application, config: ClientConfig) =
        manager.initialize(application, config)

    /**
     * @see [SdkManager.configure]
     */
    @JvmStatic
    fun configure(application: Application, block: ClientConfig.Builder.() -> Unit) =
        manager.configure(application, block)

    /**
     * @see [SdkManager.configure]
     */
    @JvmStatic
    fun configure(application: Application, config: ClientConfig) =
        manager.configure(application, config)

    /**
     * @see [BshRecyclerInterface.onCollectionVisible]
     */
    @JvmStatic
    fun onCollectionVisible(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId: String,
        model: List<RecyclerItemModel>
    ) = sdk.onCollectionVisible(sourceActivity, collectionViewKey, searchId, model)

    /**
     * @see [BshRecyclerInterface.onCollectionUpdated]
     */
    @JvmStatic
    fun onCollectionUpdated(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId: String,
        model: List<RecyclerItemModel>
    ) = sdk.onCollectionUpdated(sourceActivity, collectionViewKey, searchId, model)

    /**
     * @see [BshRecyclerInterface.onCollectionHidden]
     */
    @JvmStatic
    fun onCollectionHidden(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId: String
    ) = sdk.onCollectionHidden(sourceActivity, collectionViewKey, searchId)

    /**
     * @see [BshRecyclerInterface.trackRecyclerView]
     */
    @JvmStatic
    fun trackRecyclerView(
        recyclerView: RecyclerView,
        currentDataProvider: () -> List<RecyclerItemModel>,
        searchId: String,
        impressionThresholdBlock: (ImpressionThreshold.Builder.() -> Unit)? = null
    ) = sdk.trackRecyclerView(recyclerView, currentDataProvider, searchId, impressionThresholdBlock)

    /**
     * @see [BshRecyclerInterface.trackRecyclerView]
     */
    @JvmStatic
    fun trackRecyclerView(
        recyclerView: RecyclerView,
        currentDataProvider: () -> List<RecyclerItemModel>,
        searchId: String,
        impressionThreshold: ImpressionThreshold
    ) = sdk.trackRecyclerView(recyclerView, currentDataProvider, searchId, impressionThreshold)

    //region JAVA INTER-OP
    /* Java-idiomatic initialization of the SDK */
    /**
     * Begin building an SDK configuration in a chained fashion, finally resulting in an
     * initialize() or configure() call.
     *
     * Example usage from an [Application] class:
     *
     *     PromotedAi
     *         .buildConfiguration()
     *         .withMetricsLoggingUrl("https://myurl.com")
     *         .withMetricsLoggingApiKey("api-123")
     *         .initialize(this)
     *
     * @see [initialize]
     * @see [configure]
     */
    @JvmStatic
    fun buildConfiguration() = SdkBuilder(manager)

    /* Java-idiomatic way of tracking a RecyclerView */
    /**
     * Begin building a [RecyclerViewTrackingBuilder] configuration in a chained fashion,
     * finally resulting in a startTracking() call.
     *
     * Example usage:
     *
     *     PromotedAi
     *         .buildRecyclerViewTracking()
     *         .withTimeThreshold(1000L)
     *         .startTracking(recyclerView, recyclerViewContentProvider)
     */
    @JvmStatic
    fun buildRecyclerViewTracking() = RecyclerViewTrackingBuilder(sdk)
    //endregion
}
