package ai.benshi.android.sdk.e_commerce.impression_listener

import ai.benshi.android.sdk.e_commerce.event_models.RecyclerItemModel
import ai.benshi.android.sdk.e_commerce.impression_listener.sdk.BshRecyclerInterface
import ai.benshi.android.sdk.e_commerce.impression_listener.ui.ImpressionThreshold
import androidx.recyclerview.widget.RecyclerView

/**
 * This class is primarily to provide an easy-to-use Java API, via
 * [BshEComScroll.buildRecyclerViewTracking], so that users of the library can dynamically configure
 * and initialize impression tracking of a RecyclerView.
 *
 * While this is supported for Kotlin users, the [BshRecyclerInterface.trackRecyclerView]
 * function is recommended.
 */
class RecyclerViewTrackingBuilder internal constructor(
    private val sdk: BshRecyclerInterface
) {
    /**
     * Represents some class or object that can, on-demand, provide the latest list of [RecyclerItemModel]
     * that is backing a RecyclerView.
     *
     * Used in order to specifically derive a subset of [RecyclerItemModel] that represents the
     * data currently visible to the user.
     *
     * Note: For now, this requires that the RecyclerView has a single view-type that corresponds to
     * a view of the [RecyclerItemModel].
     */
    interface CurrentDataProvider {
        fun provideCurrentData(): List<RecyclerItemModel>
    }

    private val impressionThresholdBuilder = ImpressionThreshold.Builder()

//    fun withTimeThreshold(thresholdMillis: Long) = apply {
//        impressionThresholdBuilder.timeThresholdMillis = thresholdMillis
//    }
//
//    fun withPercentageThreshold(percentage: Double) = apply {
//        impressionThresholdBuilder.percentageThreshold = percentage
//    }

    fun startTracking(
        recyclerView: RecyclerView,
        currentDataProvider: CurrentDataProvider,
        searchId: String
    ) {
        sdk.trackRecyclerView(
            recyclerView,
            currentDataProvider::provideCurrentData,
            searchId,
            impressionThresholdBuilder.build()
        )
    }
}
