package ai.benshi.android.sdk.e_commerce.impression_listener

import ai.benshi.android.sdk.e_commerce.impression_listener.sdk.SdkManager
import android.app.Application

/**
 * This class is primarily to provide an easy-to-use Java API, via [BshEComScroll.buildConfiguration],
 * so that users of the library can dynamically set whichever [ClientConfig] options they want to
 * set.
 *
 * While this is supported for Kotlin users, the [BshEComScroll.initialize]/[BshEComScroll.configure]
 * with the [ClientConfig.Builder] configuration block is recommended.
 */
class SdkBuilder internal constructor(
    private val sdkManager: SdkManager
) {

    private val clientConfigBuilder = ClientConfig.Builder()

    /**
     * @see [BshEComScroll.configure]
     */
    @Suppress("MemberVisibilityCanBePrivate")
    fun configure(application: Application) =
        sdkManager.configure(application, clientConfigBuilder.build())
}
