package ai.benshi.android.sdk.e_commerce.impression_listener.sdk

import ai.benshi.android.sdk.e_commerce.event_models.RecyclerItemModel
import ai.benshi.android.sdk.e_commerce.impression_listener.ui.ImpressionThreshold
import android.app.Activity
import androidx.recyclerview.widget.RecyclerView

/**
 * The public-facing API for interacting with Promoted.Ai. Instances are managed internally by
 * the SDK.
 */
internal interface BshRecyclerInterface {

    fun onCollectionVisible(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId: String,
        model: List<RecyclerItemModel>
    )

    fun onCollectionUpdated(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId: String,
        model: List<RecyclerItemModel>
    )

    fun onCollectionHidden(
        sourceActivity: Activity?,
        collectionViewKey: String,
        searchId: String
    )

    fun trackRecyclerView(
        recyclerView: RecyclerView,
        currentDataProvider: () -> List<RecyclerItemModel>,
        searchId: String,
        impressionThresholdBlock: (ImpressionThreshold.Builder.() -> Unit)? = null
    )

    fun trackRecyclerView(
        recyclerView: RecyclerView,
        currentDataProvider: () -> List<RecyclerItemModel>,
        searchId: String,
        impressionThreshold: ImpressionThreshold
    )

    fun shutdown()
}
